/***************************************************************************

                                Base.h
  
 Defines the Base class for run time typed classes.  Base is a subclass of
 Managed, so we get reference counting as well.  Helper macros for defining
 subclasses of Base are in utils/BaseSub.h

***************************************************************************/

#ifndef UTILS_BASE_H
#define UTILS_BASE_H

#include <utils/Managed.h>
#include <utils/Type.h>
#include <utils/String.h>

__UTILS_BEGIN_NAMESPACE

class Base : public Managed
{
  public:
    virtual ~Base();  // virtual destructor to keep some compilers happy

    // Returns true if base is of given type or is derived from it
    bool			isOfType(Type type) const;

    // Returns true if base is a given type
    bool isType(Type type) const;

    // Routines for naming objects:
    // getName() returns "" if the object has no name.
    virtual const char* getName() const { return _name.getString(); }

    // setName("") to un-name an object
    virtual void setName(const char* n) { _name = n; }

    static Type       getClassTypeId()        /* Returns class type id */   
                                    { return Type(_class_type_id); }     
    virtual Type      getTypeId() const;      /* Returns type id      */
    virtual const char* getTypeName() const;

    // Setup type information
    static void		initClass();

  protected:
    // Constructor is protected - this is an abstract class
    Base();

  private:
    Name _name;   // the name of the instance

    static short _class_type_id; // Type id
};

__UTILS_END_NAMESPACE

#endif

