#include <stdio.h>

#include <utils/StringDict.h>

char* strings[] = { "Hello", "World", "This", "Is a",  "Test", "Hello", NULL };
char* values[] = { "Four",   "Score", "and",  "seven", "years", "ago" };

void print_data_with_cb(const char* str, char* data, void* cb_data)
{
    printf("%s: %s = %s\n", cb_data, str, data);
}

void print_data(const char* str, char* data)
{
    printf("%s = %s\n", str, data);
}

main()
{
    __UTILS::StringDict<char*>* dict = new __UTILS::StringDict<char*>(50);
    int i;

    for (i=0; strings[i]; i++) 
        if (!dict->enter(strings[i], values[i]))
            printf("%s is a duplicate\n", strings[i]);
    dict->applyToAll(print_data_with_cb, (void*) "Just for kicks");


    for (i=0;i<3; i++)
        dict->remove(strings[i]);

    char* val;
    for (i=0; strings[i]; i++) {
        if (dict->find(strings[i], val))
            printf("%s really is %s\n", strings[i], val);
        else
            printf("%s not in table\n", strings[i]);
    }

    delete dict;
}
