#include <stdio.h>

#include <utils/StringDict.h>

char* strings[] = { "Hello", "World", "This", "Is a",  "Test", "Hello", NULL };
char* values[] = { "Four",   "Score", "and",  "seven", "years", "ago" };

void print_data_with_cb(const char* str, void* data, void* cb_data)
{
    printf("%s: %s = %s\n", (char*) cb_data, str, (char*) data);
}

main()
{
    UTL_StringDict dict;
    int i;
    char* val;

    dict = SDICT_new(20);
    for (i=0; strings[i]; i++) 
        if (!SDICT_enter(dict, strings[i], values[i]))
            printf("%s is a duplicate\n", strings[i]);
    SDICT_applyToAll(dict, print_data_with_cb, (void*) "Just for kicks");


    for (i=0;i<3; i++)
        SDICT_remove(dict, strings[i]);

    for (i=0; strings[i]; i++) {
        if (SDICT_find(dict, strings[i], (void**) &val))
            printf("%s really is %s\n", strings[i], val);
        else
            printf("%s not in table\n", strings[i]);
    }

    SDICT_delete(dict);
}
