#include <stdio.h>
#include <string.h>

#include <utils/ConfigFile.h>
#include <utils/StringDict.h>

main(int argc, char** argv) 
{
    UTL_ConfigFile config;
    UTL_StringDict typenames;
    int start = 1;
    int type;
    int i, j;
    unsigned char buffer[1000];
    int max_num, res;
    bool outputting;
    void** ptr;
    
    if (!strcmp(argv[1], "output")) {
        outputting=true;
        start++;
    } else
        outputting=false;

    config = CF_new();
    typenames = SDICT_new(20);

    SDICT_enter(typenames, "int", (void*) CF_intType());
    SDICT_enter(typenames, "float", (void*) CF_floatType());
    SDICT_enter(typenames, "double", (void*) CF_doubleType());
    SDICT_enter(typenames, "char", (void*) CF_charType());
    SDICT_enter(typenames, "bool", (void*) CF_boolType());
    SDICT_enter(typenames, "string", (void*) CF_stringType());

    CF_open(config, "test.conf");

    ptr = (void**) &type; 
    for (i = start; ; i+=3) {
        if (i+3 > argc+1)
            break;

        if (SDICT_find(typenames, argv[i], ptr)) {
            max_num = atoi(argv[i+2]);
            if (max_num < 1) {
                printf("'%s' not a valid number for %s, %s\n",
                       argv[i+2], argv[i], argv[i+1]);
                continue;
            }
            res = CF_get(config, type, argv[i+1], buffer, max_num,
                         NULL, 0);
            if (res <= 0) {
                printf("Could not get %s, %s, %d\n",
                       argv[i], argv[i+1], max_num);
                continue;
            }
            printf("%s %s: ", argv[i], argv[i+1]);
            if (type == CF_intType()) {
                int* data = (int*) buffer;
                for (j=0;j<res;j++)
                    printf("%d ", data[j]);
            } else if (type == CF_floatType()) {
                float* data = (float*) buffer;
                for (j=0;j<res;j++)
                    printf("%f ", data[j]);
            } else if (type == CF_doubleType()) {
                double* data = (double*) buffer;
                for (j=0;j<res;j++)
                    printf("%f ", data[j]);
            } else if (type == CF_stringType()) {
                const char** data = (const char**) buffer;
                for (j=0;j<res;j++)
                    printf("'%s' ", data[j]);
            } else if (type == CF_charType()) {
                char* data = (char*) buffer;
                for (j=0;j<res;j++)
                    printf("%c ", data[j]);
            } else if (type == CF_boolType()) {
                bool* data = (bool*) buffer;
                for (j=0;j<res;j++)
                    printf("%d ", data[j]);
            }

            printf("\n");
        }
    }
}                    
