/***************************************************************************

                                cConfigFile.cc

  Implements a C cover functions to give C programmers access to the ConfigFile
  functionality.  See ConfigFile.cc for more documentation on each
  function

  C Cover functions implemented for the equivalent ConfigFile methods:
    CF_new, CF_delete, CF_open, CF_load, CF_close, CF_get, CF_getInt
    CF_getFloat, CF_getDouble, CF_getChar, CF_getString, CF_getBool
    CF_set, CF_getInts, CF_getFloats, CF_getDoubles, CF_getChars
    CF_getStrings, CF_getBools, CF_intType, CF_floatType, CF_doubleType
    CF_charType, CF_stringType, CF_boolType

***************************************************************************/
#include <utils/ConfigFile.h>

extern "C" {

UTL_ConfigFile CF_new()
{
    return new __UTILS::ConfigFile();
}

void CF_delete(UTL_ConfigFile cf)
{
    delete cf;
}

bool CF_open(UTL_ConfigFile cf, const char* name)
{
    return cf->open(name);
}

bool CF_parse(UTL_ConfigFile cf, const char* source)
{
    return cf->parse(source);
}

void CF_close(UTL_ConfigFile cf)
{
    cf->close();
}

int CF_get(UTL_ConfigFile cf, int type, const char* name,
           void* data, int max_num, void* default_data, int num_defaults)
{
    return cf->get(utils::Type(type),
                   name, data, max_num, default_data, num_defaults);
}

int CF_getInt(UTL_ConfigFile cf,const char* name, int def)
{
    return cf->getInt(name, def);
}

float CF_getFloat(UTL_ConfigFile cf, const char* name, float def)
{
    return cf->getFloat(name, def);
}

double CF_getDouble(UTL_ConfigFile cf, const char* name, double def)
{
    return cf->getDouble(name, def);
}

char CF_getChar(UTL_ConfigFile cf, const char* name, char def)
{
    return cf->getChar(name, def);
}

const char* CF_getString(UTL_ConfigFile cf, const char* name,
                         const char* def)
{
    return cf->getString(name, def);
}

bool CF_getBool(UTL_ConfigFile cf, const char* name, bool def)
{
    return cf->getBool(name, def);
}

int CF_getInts(UTL_ConfigFile cf, const char* name,
               int* data, int max_num,
               int* default_data, int num_defaults)
{
    return cf->getInts(name, data, max_num, default_data, num_defaults);
}

int CF_getFloats(UTL_ConfigFile cf, const char* name,
                 float* data, int max_num,
                 float* default_data, int num_defaults)
{
    return cf->getFloats(name, data, max_num, default_data, num_defaults);
}

int CF_getDoubles(UTL_ConfigFile cf, const char* name,
                  double* data, int max_num,
                  double* default_data, int num_defaults)
{
    return cf->getDoubles(name, data, max_num, default_data, num_defaults);
}

int CF_getChars(UTL_ConfigFile cf, const char* name,
                char* data, int max_num,
                char* default_data, int num_defaults)
{
    return cf->getChars(name, data, max_num, default_data, num_defaults);
}

int CF_getStrings(UTL_ConfigFile cf, const char* name,
                  const char** data, int max_num,
                  const char** default_data, int num_defaults)
{
    return cf->getStrings(name, data, max_num, default_data, num_defaults);
}

int CF_getBools(UTL_ConfigFile cf, const char* name,
                bool* data, int max_num,
                bool* default_data, int num_defaults)
{
    return cf->getBools(name, data, max_num, default_data, num_defaults);
}


int CF_intType()
{
    return __UTILS::ConfigFile::intType().getKey();
}

int CF_floatType()
{
    return __UTILS::ConfigFile::floatType().getKey();
}

int CF_doubleType()
{
    return __UTILS::ConfigFile::doubleType().getKey();
}

int CF_charType()
{
    return __UTILS::ConfigFile::charType().getKey();
}

int CF_stringType()
{
    return __UTILS::ConfigFile::stringType().getKey();
}

int CF_boolType()
{
    return __UTILS::ConfigFile::boolType().getKey();
}

}
