#include <stdio.h>
#include <unistd.h>

#include <utils/BinPlayer.h>

int main()
{
  __UTILS::BinPlayer player;

  float logvals[3];
  float other[3];

  player.expect("TEST", "sth", "Float", &logvals[0]);
  player.expect("TEST", "cth", "Float", &logvals[1]);
  player.expect("TEST", "th", "Angle", &logvals[2]);
  player.expect("ARRAY", "all",
                "Array: size=3; spec format {Float: interpolate=false;}",
                &other[0]);

  if (!player.open("test.log")) {
    printf("Could not open test.log for playing\n");
    exit(-1);
  }

  __UTILS::Time::init();
  __UTILS::Time::useDiscreteTime();
  __UTILS::Time::setTimeStep(0.05);

  player.setZero(__UTILS::Time::getTimeOfDay());

  __UTILS::Time log_time;
  long sec, usec;
  while (1) {
    log_time =  __UTILS::Time::getTimeOfDay();
    log_time.getValue(sec, usec);
    printf("At time %ld %ld: ", sec, usec);
    if (!player.get("TEST", log_time))
      break;
    log_time.getValue(sec, usec);
    printf("%ld %ld: %f %f %f\n", sec, usec, logvals[0], logvals[1],
           logvals[2]);
    player.get("ARRAY", log_time);
    log_time.getValue(sec, usec);
    printf("\t %ld %ld:%f %f %f\n", sec, usec, other[0], other[1], other[2]);
    __UTILS::Time::stepTime();
    log_time = __UTILS::Time::getTimeOfDay();
  }
}
    
