#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
/*****************************************************/
void usage()
{
  printf("\tConvert date string to Unix seconds.\n");
  printf("\tconvert_to_secs Wed Nov 20 13:01:08 2002\n");
}
/*****************************************************/
int month_to_int(char *m)
{
  int i;
  char *month[12] = {"Jan","Feb","Mar","Apr","May","Jun",\
		     "Jul","Aug","Sep","Oct","Nov","Dec"};
  for (i = 0; i < 12; i++)
    {
      if (!strncmp(m,month[i],3))
	return(i);
    }
  return(-1);
}
/*****************************************************/
int day_to_int(char *d)
{
  int i;
  char *day[7] = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
  for (i = 0; i < 7; i++)
    {
      if (!strncmp(d,day[i],3))
	return(i);
    }
  return(-1);
}
/*****************************************************/
int main (int argc, char **argv)
{
  struct tm t;
  int mday,hour,min,sec,year;
  char temp[256];
  char day_string[10];
  char month_string[10];
  time_t time;
  

  scanf("%s %s %s %d %d %c %d %c %d %d",\
	temp,day_string,month_string,&mday,&hour,temp,&min,temp,&sec,&year);
  if (day_to_int(day_string) == -1)
    {fprintf(stderr,"Inavlid day.\n");
    return(-1);}
  if (month_to_int(month_string) == -1)
    {fprintf(stderr,"Invalid month.\n");
    return(-1);}
  t.tm_sec = sec;
  t.tm_min = min;
  t.tm_hour = hour;
  t.tm_mday = mday;
  t.tm_year = year - 1900;
  t.tm_mon = month_to_int(month_string);
  t.tm_wday = day_to_int(day_string);
  time = mktime(&t);
  printf("%ld\n",time);
  return(0);
}
/*****************************************************/
