#ifndef DRIVER
#include <sys/time.h>
#endif
#define DEVICE_NAME "bc635"

#define BC635_IOC_MAGIC 'B'
#define BC635_GETNEWTIME   _IO(BC635_IOC_MAGIC, 1)
#define BC635_GETOLDTIME   _IO(BC635_IOC_MAGIC, 2)
#define BC635_GETEVENTTIME _IO(BC635_IOC_MAGIC, 3)
#define BC635_IOC_MAXNR 3

struct bc635_time_struct{
  unsigned long secs;
  unsigned long usecs;
  unsigned char nsecs;
  unsigned char status;
  struct timeval sys_time;
};

typedef struct
{
  union 
   {
     struct bc635_time_struct new_time_struct;    
     struct timeval timeval_struct;
   }bc635; 
} BC635_IOCTL_STRUCT;
extern int bc635_gettimeofday(int fd,struct timeval *tv);
extern int bc635_getnewtimeofday(int fd,struct bc635_time_struct *tv);
extern int bc635_geteventtime(int fd,struct bc635_time_struct *tv);
