#ifndef INTF_TIME_SOURCE_UTILS_H
#define INTF_TIME_SOURCE_UTILS_H

#include <TimeSource/TimeSource.h>

class UtilsTimeSource : public TimeSource {
 public:
  UtilsTimeSource(bool continuous, float time_constant, float step);
  virtual ~UtilsTimeSource() {}

  virtual bool getTime(utils::Time&);
  virtual int getKey();
  virtual bool setTime(const utils::Time&, int key);
  virtual bool setScale(double scale, int key);
  virtual bool advanceTime(double sleep_time);

 protected:
  void setTime(const utils::Time&);

 private:
  int _cur_key;
  utils::Time _offset;
};

#endif
