#ifndef INTF_TIME_SOURCE_DRIVEN_H
#define INTF_TIME_SOURCE_DRIVEN_H

#include <TimeSource/TimeSource.h>

class DrivenTimeSource : public TimeSource {
 public:
  DrivenTimeSource(bool exclusive);
  virtual ~DrivenTimeSource() {}

  virtual bool getTime(utils::Time&);
  virtual int getKey();
  virtual bool setTime(const utils::Time&, int key);
  virtual void setExtent(const utils::Time& beginning,
                         const utils::Time& ending);
  virtual bool getExtent(utils::Time& beginning, utils::Time& ending);
  virtual bool advanceTime(double step_time) { return false; }

 private:
  bool _exclusive;
  bool _key_given;
  utils::Time _time;
  utils::Time _beginning, _ending;
};

#endif
