#ifndef BUFFER_IMG_DISPLAY_H
#define BUFFER_IMG_DISPLAY_H

#include <utils/List.h>
#include <ImgDisplay/ImgDisplay.h>

class BufferDisplay : public ImgDisplay
{
 public:
  virtual ~BufferDisplay();

  virtual void destroyWindow(ImgDisplay::Window*);
  virtual void destroyAllWindows();
  void addWindow(ImgDisplay::Window*);

 private:
  utils::List<Window> _windows;
};

class ColorConverter;
class BufferWindow : public ImgDisplay::Window
{
 public:
  BufferWindow(ImgDisplay* display, int width, int height, 
               int dest_bytes_per_line,
               ImgDisplay::ColorType src_type,ImgDisplay::ColorType dest_type);

  virtual ImgDisplay::ColorType colorType() const { return _src_type; }
  virtual int bytesPerPixel() const { return _src_bytes_per_pixel; }
  virtual int bytesPerLine() const { return getWidth()*_src_bytes_per_pixel; }

  virtual void pixel(int x, int y, ImgDisplay::Color colorID);
  virtual void fill(unsigned char* src);
  virtual void clear();
  ColorConverter* converter() const { return _converter; }

  void setDest(unsigned char* dest) { _dest = dest; }
  unsigned char* getDest() const { return _dest; }

  static int getBytesPerPixel(ImgDisplay::ColorType type);

 private:
  ImgDisplay::ColorType _src_type;
  ImgDisplay::ColorType _dest_type;
  int _src_bytes_per_pixel;
  ColorConverter* _converter;
  unsigned char* _dest;
};

#endif
