#ifndef EMBEDDED_CONFIG_SOURCE_H
#define EMBEDDED_CONFIG_SOURCE_H

#include <utils/String.h>
#include <ConfigSource/File.h>

struct EmbeddedCallbackData;

class EmbeddedConfigSource : public FileConfigSource
{
 public:
  EmbeddedConfigSource(ConfigSource* embedded, const char* name);
  virtual ~EmbeddedConfigSource();
                                                
  virtual bool attach(utils::Type type, const char* name,
                      void* data, int max_num=1,
                      ConfigCallback notify=NULL, void* cb_data = NULL,
                      void* default_data=NULL, int num_defaults=1);
  virtual bool set(const char* name, const char* value);
  virtual bool set(utils::Type, const char* name, void* data, int num_values);
  virtual bool processEvents(double timeout=-1.0);
  virtual bool refresh();
  virtual void reportState(ModuleState);
  virtual void setStatus(float status);
  virtual void setConfidence(float confidence);
  virtual void setStatusMessage(const char* msg);
  

  bool initialize();

  void doCallback(EmbeddedCallbackData* ecd, const char* name, utils::Type t,
                  void* data, int num_elems);

 private:
  const char* make_full_name(utils::String& full_name, const char* name);

 private:
  ConfigSource* _container;
  utils::String _name;
};    

#endif
