#ifndef INTF_ACTIVE_CONFIG_SOURCE
#define INTF_ACTIVE_CONFIG_SOURCE

#include <ConfigSource/File.h>
#include <utils/StringDict.h>
#include <utils/List.h>

class ActiveList;
class SourceWatch;

struct ActiveElem {
  ~ActiveElem() {
    // printf("Delete %x %s\n", (unsigned) this, name);
    delete [] name; name=NULL;
  }
  utils::Type type;
  char* name;
  void* data;
  int max_num;
  ConfigCallback callback;
  void* cb_data;
};

class ActiveConfigSource : public FileConfigSource
{
 public:
  bool open(const char* name);
  void instrument();

  virtual bool attach(utils::Type type, const char* name,
                      void* data, int max_num=1,
                      ConfigCallback notify=NULL, void* cb_data=NULL,
                      void* default_data=NULL, int num_defaults=1) {
    return watch(type, name, data, max_num, notify, cb_data,
                 default_data, num_defaults) != NULL;
  }

  ActiveElem* watch(utils::Type type, const char* name,
                     void* data, int max_num,
                     ConfigCallback notify, void* cb_data,
                     void* default_data, int num_defaults);
  void unwatch(utils::ConfigElem*, ActiveElem*);

  virtual bool refresh();

  // not really public - only used by internal classes
  void removeCallback(ActiveElem*);

 private:
  void reapply_watches();
  SourceWatch* do_watch(utils::Type type, const char* name,
                        void* data, int max_num,
                        ConfigCallback notify, void* cb_data,
                        void* default_data, int num_defaults);

 private:
  utils::ManagedList<ActiveElem> _active_elems;
};    

#endif
