#include <TimeSource/TimeSource.h>

static TimeSource* DefaultSource = NULL;

TimeSource::TimeSource()
{
  if (!DefaultSource) {
    DefaultSource = this;
    DefaultSource->ref();
  }
}

TimeSource::~TimeSource()
{
  if (DefaultSource == this) 
    DefaultSource = NULL;
}

utils::Time TimeSource::now()
{
  if (DefaultSource) {
    utils::Time t;
    if (DefaultSource->getTime(t))
      return t;
  }

  return utils::Time::getTimeOfDay();
}

int TimeSource::getSettingKey()
{
  if (DefaultSource)
    return DefaultSource->getKey();
  else
    return -1;
}

bool TimeSource::setCurTime(const utils::Time& t, int key)
{
  if (DefaultSource)
    return DefaultSource->setTime(t, key);
  else
    return false;
}

void TimeSource::setDefaultTimeSource(TimeSource* source)
{
  if (source == DefaultSource)
    return;
  if (DefaultSource)
    DefaultSource->unref();
  DefaultSource = source;
  if (DefaultSource)
    DefaultSource->ref();
}

TimeSource* TimeSource::getDefaultTimeSource()
{
  return DefaultSource;
}

void TimeSource::extent(const utils::Time& beginning,
                        const utils::Time& ending)
{
  if (!DefaultSource)
    return;
  DefaultSource->setExtent(beginning, ending);
}
