#include <stdio.h>

#include <TimeSource/ShmemDriver.h>
#include <TimeSource/shmem_format.h>

#include <ipt/ipt.h>
#include <ipt/sharedmem.h>

#include <utils/ConfigFile.h>

TimeSource* create_TimeSource_shmemdriver(TimeSourceGenerator*,
                                          utils::ConfigFile* params,
                                          utils::SymbolTable* globals)
{
  IPCommunicator* com =
    IPCommunicator::Communicator(globals, 
                                 params->getString("ipt_spec",
                                                   "unix:port=0;"));
  if (!com)
    return NULL;

  const char* mem_name = params->getString("name", TIME_SHMEM_NAME);
  char buffer[200];
  sprintf(buffer, "managed: name=%s; owner=true;", mem_name);
  const char* mem_spec = params->getString("mem", buffer);
  IPSharedMemory* shm = 
    com->OpenSharedMemory(mem_spec, TIME_SHMEM_FORMAT,
                          sizeof(ShmemTimeStruct));

  if (!shm) {
    printf("Problem opening shared memory %s\n", mem_spec);
    return NULL;
  }

  return new ShmemDriverTimeSource(shm);
}

ShmemDriverTimeSource::ShmemDriverTimeSource(IPSharedMemory* shm)
  : DrivenTimeSource(true)
{
  _shm = shm;
}

bool ShmemDriverTimeSource::setTime(const utils::Time& t, int key)
{
  if (!DrivenTimeSource::setTime(t, key))
    return false;

  ShmemTimeStruct tstruct;
  long secs, usecs;
  t.getValue(secs, usecs);
  tstruct.secs = secs;
  tstruct.usecs = usecs;
  _shm->PutFormattedData(&tstruct);

  return true;
}
