//
// $Id: x-utils.cc,v 1.1 2002/12/02 19:45:16 jayg Exp $
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS OR A PARTICULAR PURPOSE. See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston MA
// 02111-1307, USA.
//
// This file uses PERCEPS style comments to facilitate automatic
// documentation generation. More information on PERCEPS can be
// found at "http://starship.python.net/crew/tbryan/PERCEPS".
//
// Author: Ross J. Micheals
//         rmicheals@lehigh.edu
//
// (c) 1999-2000 Ross J. Micheals

#include <SPU-Toolbox/x-utils.h>

const char* 
XEvent_type_to_str(int xev_type) 
{
  // This is the not the prettiest way of doing this, but it's
  // independent of the actualy values of these defines, as opposed to
  // a const string array.

  static const char* KeyPress_str         = "KeyPress";
  static const char* KeyRelease_str       = "KeyRelease";
  static const char* ButtonPress_str      = "ButtonPress";
  static const char* ButtonRelease_str    = "ButtonRelease";
  static const char* MotionNotify_str     = "MotionNotify";
  static const char* EnterNotify_str      = "EnterNotify";
  static const char* LeaveNotify_str      = "LeaveNotify";
  static const char* FocusIn_str          = "FocusIn";
  static const char* FocusOut_str         = "FocusOut";
  static const char* KeymapNotify_str     = "KeymapNotify";
  static const char* Expose_str           = "Expose";
  static const char* GraphicsExpose_str   = "GraphicsExpose";
  static const char* NoExpose_str         = "NoExpose";
  static const char* VisibilityNotify_str = "VisibilityNotify";
  static const char* CreateNotify_str     = "CreateNotify";
  static const char* DestroyNotify_str    = "DestroyNotify";
  static const char* UnmapNotify_str      = "UnmapNotify";
  static const char* MapNotify_str        = "MapNotify";
  static const char* MapRequest_str       = "MapRequest";
  static const char* ReparentNotify_str   = "ReparentNotify";
  static const char* ConfigureNotify_str  = "ConfigureNotify";
  static const char* ConfigureRequest_str = "ConfigureRequest";
  static const char* GravityNotify_str    = "GravityNotify";
  static const char* ResizeRequest_str    = "ResizeRequest";
  static const char* CirculateNotify_str  = "CirculateNotify";
  static const char* CirculateRequest_str = "CirculateRequest";
  static const char* PropertyNotify_str   = "PropertyNotify";
  static const char* SelectionClear_str   = "SelectionClear";
  static const char* SelectionRequest_str = "SelectionRequest";          
  static const char* SelectionNotify_str  = "SelectionNotify";
  static const char* ColormapNotify_str   = "ColormapNotify";
  static const char* ClientMessage_str    = "ClientMessage";
  static const char* MappingNotify_str    = "MappingNotify";
  static const char* Unknown_str          = "unknown";

  const char* rv;
  switch (xev_type) {
  case KeyPress:         rv = KeyPress_str;         break;
  case KeyRelease:       rv = KeyRelease_str;       break;
  case ButtonPress:      rv = ButtonPress_str;      break;
  case ButtonRelease:    rv = ButtonRelease_str;    break;
  case MotionNotify:     rv = MotionNotify_str;     break;
  case EnterNotify:      rv = EnterNotify_str;      break;
  case LeaveNotify:      rv = LeaveNotify_str;      break;
  case FocusIn:          rv = FocusIn_str;          break;
  case FocusOut:         rv = FocusOut_str;         break;
  case KeymapNotify:     rv = KeymapNotify_str;     break;
  case Expose:           rv = Expose_str;           break;
  case GraphicsExpose:   rv = GraphicsExpose_str;   break;
  case NoExpose:         rv = NoExpose_str;         break;
  case VisibilityNotify: rv = VisibilityNotify_str; break;
  case CreateNotify:     rv = CreateNotify_str;     break;
  case DestroyNotify:    rv = DestroyNotify_str;    break;
  case UnmapNotify:      rv = UnmapNotify_str;      break;
  case MapNotify:        rv = MapNotify_str;        break;
  case MapRequest:       rv = MapRequest_str;       break;
  case ReparentNotify:   rv = ReparentNotify_str;   break;
  case ConfigureNotify:  rv = ConfigureNotify_str;  break;
  case ConfigureRequest: rv = ConfigureRequest_str; break;
  case GravityNotify:    rv = GravityNotify_str;    break;
  case ResizeRequest:    rv = ResizeRequest_str;    break;
  case CirculateNotify:  rv = CirculateNotify_str;  break;
  case CirculateRequest: rv = CirculateRequest_str; break;
  case PropertyNotify:   rv = PropertyNotify_str;   break;
  case SelectionClear:   rv = SelectionClear_str;   break;
  case SelectionRequest: rv = SelectionRequest_str; break;
  case SelectionNotify:  rv = SelectionNotify_str;  break;
  case ColormapNotify:   rv = ColormapNotify_str;   break;
  case ClientMessage:    rv = ClientMessage_str;    break;
  case MappingNotify:    rv = MappingNotify_str;    break;
  default:               rv = Unknown_str;          break;
  }
  return(rv);
}
