#include <stdio.h>
#include <unistd.h>

#include <utils/SymbolTable.h>

#include <ImgDisplay/ImgDisplay.h>

int main(int argc, char **argv)
{
  if (argc < 2) {
    printf("Need specification\n");
    exit(-1);
  }
  int exit_type = 0;
  if (argc > 2) {
    exit_type = atoi(argv[2]);
  }

  utils::SymbolTable* globals = new utils::SymbolTable();
  ImgDisplay* disp = ImgDisplay::create(argv[1], globals);
  if (!disp) {
    fprintf(stderr, "'%s' is not a valid image display\n", argv[1]);
    exit(-1);
  }

  ImgDisplay::Window* win = disp->createWindow("Test", 640, 480, "grey8");
  if (!win) {
    printf("Could not create window\n");
    exit(-1);
  }
  sleep(1);
  printf("Drawing\n");
  win->begin();
  win->clear();
  win->fill(ImgDisplay::Pink);
  win->fillBox(100, 100, 200, 200, ImgDisplay::White);
  win->setLineWidth(3);
  win->box(120,120,180,180, ImgDisplay::Blue);
  win->line(300, 300, 400, 450, ImgDisplay::Red);
  win->circle(400, 50, 20, ImgDisplay::Orange);
  win->text(20, 80, "Hello world", ImgDisplay::Yellow);
  win->setLineWidth(0);
  win->text(20, 80, "Hello world", ImgDisplay::Black);
  win->text(0,0,"Corner TTTTTTT", ImgDisplay::White);
  win->end();

  if (exit_type == 0) {
    printf("Hit return to exit: ");
    fflush(stdout);
    char buffer[20];
    fgets(buffer, 19, stdin);
  } else if (exit_type == 1) {
    int x, y;
    unsigned int modifiers;
    if (win->waitForSelection(x, y, modifiers)) {
      printf("Exiting with click at %d %d (%x)\n", x, y, modifiers);
    } else
      printf("Exiting on selection error\n");
  } else if (exit_type == 2) {
    printf("Sleeping for 5 seconds\n");
    sleep(5);
  }

  printf("Destroying window\n");
  disp->destroyWindow(win);
  
  printf("Invoking destructors\n");
  delete globals;
}
