// ---------------------------------------------------------------
// SPU-Toolbox
//
//        File: pnm_helper.h
// Description: Support PNM routine declarations
// ---------------------------------------------------------------
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS OR A PARTICULAR PURPOSE. See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston MA
// 02111-1307, USA.
//
// This file may use Doxgen style comments to facilitate automatic
// documentation generation. More information on PERCEPS can be
// found at "http://www.stack.nl/~dimitri/doxygen/index.html".
//
// Author: Ross J. Micheals
//         rjm2@eecs.lehigh.edu
//
// (c) 1999-2001 Ross J. Micheals

/*!
  
  \file   pnm_helper.h
  \brief  Support PNM routine declarations
  \author Ross J. Micheals (rjm2@eecs.lehigh.edu)

*/
#include <SPU-Toolbox/config.h>
#include <SPU-Toolbox/SPU-Types.h>

extern "C" {
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
}

bool
pgm_write_helper(const char* filename, const int& cols, const int& rows,
		 const int mode, int maxval);

bool
pnm_read_helper(const char* filename, 
		int& in_cols, int& in_rows, int& in_mode, 
		int&            in_bytes_per_line, 
		unsigned char*& raw_mem,
		int&            raw_memsize,
		unsigned char*& aligned_mem,
		int&            aligned_memsize,
		const int       byte_alignment);

