#include <utils/List.h>
#include <utils/ConfigFile.h>

#include <ImgDisplay/ImgDisplay.h>

class DummyWindow : public ImgDisplay::Window {
public:
  DummyWindow(ImgDisplay* disp, int width, int height)
    : Window(disp, width, height) {
  }

  virtual ImgDisplay::ColorType colorType() const { return ImgDisplay::Grey8; }
  virtual int bytesPerPixel() const { return 1; }
  virtual int bytesPerLine() const { return _width; }

  virtual void pixel(int x, int y, ImgDisplay::Color colorID) {}
  virtual void fill(unsigned char* src) {}
  virtual bool begin() { return true; }
  virtual void end() {}
};

class DummyDisplay : public ImgDisplay {
public: 
  virtual Window* createWindow(const char* title, int width, int height,
                               ImgDisplay::ColorType) {
    DummyWindow* win = new DummyWindow(this, width, height);
    _windows.append(win);
    return win;
  }
  virtual void destroyWindow(Window* win) {
    _windows.remove(win);
    delete win;
  }
  virtual void destroyAllWindows() {
    _windows.clear();
  }

private:
  utils::ManagedList<Window> _windows;
};

ImgDisplay* create_ImgDisplay_dummy(utils::Generator<ImgDisplay>* gen,
                                    utils::ConfigFile* params,
                                    utils::SymbolTable* globals)
{
  return new DummyDisplay();
}

