#include <stdio.h>

#include <utils/SymbolTable.h>

#include <ConfigSource/ConfigSource.h>

int main(int argc, char** argv)
{
  if (argc < 4)
    return -1;

  utils::SymbolTable* globals = new utils::SymbolTable;
  globals->set("ModuleName", "SSetTester");

  ConfigSource* config_src = ConfigSource::create(argv[1], globals);
  if (!config_src) {
    printf("Invalid config source '%s'\n", argv[1]);
    exit(-1);
  }

  printf("Setting '%s' = '%s'\n", argv[2], argv[3]);
  if (config_src->set(argv[2], argv[3])) {
    printf("Success!\n");
  } else
    printf("Failure!\n");

  delete globals;
}
