#include <stdio.h>
#include <unistd.h>

#include <utils/SymbolTable.h>
#include <utils/StringDict.h>
#include <utils/Output.h>
#include <utils/SpecElem.h>
#include <utils/ConfigFile.h>

#include <ConfigSource/ConfigSource.h>

static void test_notify(const char* name, utils::Type type,
                        void* data, int, void*)
{
  printf("Changing primitive %s to %d\n", name, *(bool*) data);
}

static void struct_notify(const char* name, utils::Type type,
                          void* data, int, void*)
{
  printf("Changing structure %s\n", name);
}

int main(int argc, char** argv)
{

  if (argc < 3)
    return -1;

  utils::SymbolTable* globals = new utils::SymbolTable;
  globals->set("ModuleName", "ConfigTester");

  ConfigSource* config_src = ConfigSource::create(argv[1], globals);
  if (!config_src) {
    printf("Invalid config source '%s'\n", argv[1]);
    exit(-1);
  }

  utils::StringDict<int> typenames;
  typenames.enter("int", utils::ConfigFile::intType().getKey());
  typenames.enter("float", utils::ConfigFile::floatType().getKey());
  typenames.enter("double", utils::ConfigFile::doubleType().getKey());
  typenames.enter("char", utils::ConfigFile::charType().getKey());
  typenames.enter("bool", utils::ConfigFile::boolType().getKey());
  typenames.enter("string", utils::ConfigFile::stringType().getKey());

  int start = 2;

  int j;
  unsigned char buffer[1000];
  bool set_test = false;
  for (int i = start; ; i+=3) {
    if (i+3 > argc+1)
      break;
    if (!strcmp(argv[i], "set")) {
      set_test = true;
      continue;
    }

    int key;
    if (typenames.find(argv[i], key)) {
      utils::Type type(key);
      int max_num = atoi(argv[i+2]);
      if (max_num < 1) {
        printf("'%s' not a valid number for %s, %s\n",
               argv[i+2], argv[i], argv[i+1]);
        continue;
      }
      int res = config_src->get(type, argv[i+1], buffer, max_num);
      if (res <= 0) {
        printf("Could not get %s, %s, %d\n",
               argv[i], argv[i+1], max_num);
        continue;
      }
      printf("%s %s: ", argv[i], argv[i+1]);
      if (type == utils::ConfigFile::intType()) {
        int* data = (int*) buffer;
        for (j=0;j<res;j++)
          printf("%d ", data[j]);
      } else if (type == utils::ConfigFile::floatType()) {
        float* data = (float*) buffer;
        for (j=0;j<res;j++)
          printf("%f ", data[j]);
      } else if (type == utils::ConfigFile::doubleType()) {
        double* data = (double*) buffer;
        for (j=0;j<res;j++)
          printf("%f ", data[j]);
      } else if (type == utils::ConfigFile::stringType()) {
        const char** data = (const char**) buffer;
        for (j=0;j<res;j++)
          printf("'%s' ", data[j]);
      } else if (type == utils::ConfigFile::charType()) {
        char* data = (char*) buffer;
        for (j=0;j<res;j++)
          printf("%c ", data[j]);
      } else if (type == utils::ConfigFile::boolType()) {
        bool* data = (bool*) buffer;
        for (j=0;j<res;j++)
          printf("%d ", data[j]);
      }

      printf("\n");
    }
  }

  if (set_test) {
    bool running;
    config_src->processEvents(1.0);
    config_src->attachBool("simple.test", &running);
    config_src->notify("simple.test", test_notify);
    config_src->notify("simple", struct_notify);

    printf("Before %d %d\n", config_src->getBool("simple.test"), running);
    config_src->setBool("simple.test", true);

    config_src->processEvents(2.0);

    printf("After %d\n", running);
  }

  delete globals;
}
