#include <stdio.h>
#include <unistd.h>

#include <utils/SymbolTable.h>
#include <utils/StringDict.h>
#include <utils/Output.h>
#include <utils/SpecElem.h>
#include <utils/ConfigFile.h>

#include <ConfigSource/ConfigSource.h>

void change_val(const char* name, utils::Type, void* data, int, void* cb_data)
{
  printf("%s: Changed value of %s to %s\n", (char*) cb_data,
         name, (*(utils::String**) data)->getString());
}

int main(int argc, char** argv)
{

    if (argc < 3)
        return -1;

    utils::SymbolTable* globals = new utils::SymbolTable();
    globals->set("ModuleName", "ConfigTester");

    ConfigSource* config_src = ConfigSource::create(argv[1], globals);

    const char* val;
    if (!config_src->attachString(argv[2], &val, 0,
                                  change_val, (void*) "Hello")) {
        printf("Cannot attach %s\n", argv[2]);
        exit(-1);
    }

    config_src->set(argv[2], "25");
    config_src->sleep(1500);

    delete globals;
}

    
