/** \file
    Implements the PlayerVehPoseSource interface instance
    \ingroup VehPoseGroup
*/
#include <iostream>

#include <utils/ConfigFile.h>
#include <utils/Player.h>
#include <TimeSource/TimeSource.h>

#include "VehPoseSource.h"
#include "VehPosePlayer.h"

/** Player interface definition for VehPoseSource.
*/
class PlayerVehPoseSource : public VehPoseSource {
 public:
  /// \copydoc VehPoseSource::getCurPose
  virtual bool getCurPose(utils::Time& time,
                          VehPose& pose, bool blocking = true);

  /// \copydoc VehPoseSource::getPose
  virtual bool getPose(utils::Time time, VehPose& pose);

  /// Initialization routine
  bool init(utils::ConfigFile& params, utils::SymbolTable* globals);

 private:
  VehPosePlayer _player;  ///< the pose player
};

/// The required creation function for the "player" tag
VehPoseSource* create_VehPoseSource_player(VehPoseSourceGenerator* gen,
                                           utils::ConfigFile* params,
                                           utils::SymbolTable* globals)
{
  PlayerVehPoseSource* intf = new PlayerVehPoseSource();
  if (!intf->init(*params, globals)) {
    delete intf;
    return NULL;
  }
  return intf;
}

bool PlayerVehPoseSource::init(utils::ConfigFile& params,
                            utils::SymbolTable* globals)
{
  return _player.open(params, globals);
}

bool PlayerVehPoseSource::getCurPose(utils::Time& time, VehPose& pose,
                                     bool blocking)
{
  return _player.nextPose(time, pose, blocking);
}

bool PlayerVehPoseSource::getPose(utils::Time time, VehPose& pose)
{
  return _player.getPose(time, pose);
}


