#ifndef INTF_VEH_POSE_STRUCTS_H
#define INTF_VEH_POSE_STRUCTS_H

/** \addtogroup VehPoseGroup 
    @{
*/

/** \file
    Defines the structures for the vehicle pose interface. 
*/

/** Structure for packaging vehicle pose data for transport
 */
struct VehPoseDataStruct {
  double x;    ///< X position 
  double y;    ///< Y position 
  float z;     ///< Z position
  float ori[4]; ///< Orientation quaternion
};
    
/** Defines marshalling format for \ref VehPoseDataStruct */
#define VEH_POSE_DATA_FMT "{double, double, float, [float:4]}"
/* note if you change the VehPoseDataStruct, you must change the above, and,
   possibly, the declarations in the logger and player */

/** Structure for packaging road data for transport via shared memory
 */
struct VehPoseShmemStruct {
  int secs;  ///< Time in seconds for data
  int usecs; ///< Remaining time in microseconds for data
  VehPoseDataStruct data;  ///< The data
};

/** Defines marshalling format for \ref VehPoseShmemStruct */
#define VEH_POSE_SHMEM_FMT "{int, int, " VEH_POSE_DATA_FMT " }"

/** Define the default VehPose shared memory name */
#define VEH_POSE_SHMEM_NAME "VehPoseData"

/** @} */

#endif
