/** \file
    Defines the VehPoseLogger class
    \ingroup VehPoseGroup
 */
#ifndef VEH_POSE_DEST_LOGGER_H
#define VEH_POSE_DEST_LOGGER_H

#include <vector>
#include <utils/Logger.h>

#include <VehPoseDest/VehPoseStructs.h>
#include <VehPoseDest/VehPose.h>

namespace utils {
  class ConfigFile;
  class Vec3d;
};

/** Standalone class for logging road information.
    This class lets you open a structured canned data file and log data
    to it

    \ingroup VehPoseGroup
*/
class VehPoseLogger {
 public:
  /** Open a file for logging.
      \param[in] name Name of file to open:  this must be an absolute file name
      \param[in] header An optional configuration file to include (modified by
                        version information) in the output as a header.
      \return \p true on success, \p false on failure
  */
  bool open(const char* name, const utils::ConfigFile* header=NULL);

  /** Open a file for logging.
      \param[in] header A configuration file which can include a \p name field
                        for specifying the file to open (which will default to
                        \p VehPose.raw.  This configuration file (modified by 
                        version information) will be included in the output 
                        as a header.
      \return \p true on success, \p false on failure
  */      
  bool open(utils::ConfigFile& header);

  /** Log a set of road points tagged with a time
      \param[in] time Time the road points were detected
      \param[in] pose The vehicle pose
      \return \p true for success, \p false for failure
  */
  bool logPoints(utils::Time time, const VehPose& pose);

 private:
  utils::Logger _logger;      ///< The structured data logger
  VehPoseDataStruct _output_area; ///< Packaged road information
};

#endif
