/** \file
    Implements the VehPoseLogger class
    \ingroup VehPoseGroup
*/
#include <utils/Linear.h>
#include <utils/ConfigFile.h>

#include "VehPoseLogger.h"

bool VehPoseLogger::open(const char* name,
                         const utils::ConfigFile* user_header)
{
  utils::ConfigFile header;

  // copy user header information if there is any
  if (user_header) {
    utils::ConfigFile::copy(*user_header, header);
  }

  // set the data format major and minor version numbers in the header
  header.setInt("int DataFormat.version_major", 1);
  header.setInt("int DataFormat.version_minor", 0);

  // make sure logger is closed
  _logger.close();

  // hook up logger to _output_area
  _logger.declare("x", "double", &_output_area.x);
  _logger.declare("y", "double", &_output_area.y);
  _logger.declare("z", "float", &_output_area.z);
  _logger.declare("ori", "[float : 4]", &_output_area.ori);

  // open the file, and return status as the result
  return _logger.open(name, header);
}

bool VehPoseLogger::open(utils::ConfigFile& header)
{
  return open(header.getString("name", "VehPose.raw"), &header);
}

bool VehPoseLogger::logPoints(utils::Time time, const VehPose& pose)
{
  // setup output area
  _output_area.x = pose.pos.x;
  _output_area.y = pose.pos.y;
  _output_area.z = pose.pos.z;
  _output_area.ori[0] = pose.ori[0];
  _output_area.ori[1] = pose.ori[1];
  _output_area.ori[2] = pose.ori[2];
  _output_area.ori[3] = pose.ori[3];

  // log _output_area
  bool res = _logger.log(time);

  // return the result of the log
  return res;
}

