/** \file
    Implements the LoggerRoadDest interface instance
    \ingroup RoadGroup
*/

#include "RoadDest.h"
#include "RoadLogger.h"

/// Logging interface definition for RoadDest
class LoggerRoadDest : public RoadDest {
 public:
  /// \copydoc RoadDest::outputPoints
  virtual bool outputPoints(utils::Time time,
                            const std::vector<utils::Vec3d>& points);

  /// Initialization routine
  bool init(utils::ConfigFile& params);

 private:
  RoadLogger _logger;  ///< the packaged logger
};

/// The required creation function for the "logger" tag
RoadDest* create_RoadDest_logger(RoadDestGenerator*,
                                 utils::ConfigFile* params,
                                 utils::SymbolTable* globals)
{
  LoggerRoadDest* intf = new LoggerRoadDest();
  if (!intf->init(*params)) {
    delete intf;
    return NULL;
  }
  return intf;
}

bool LoggerRoadDest::init(utils::ConfigFile& params)
{
  return _logger.open(params);
}

bool LoggerRoadDest::outputPoints(utils::Time time,
                                  const std::vector<utils::Vec3d>& points)
{
  return _logger.logPoints(time, points);
}



  
