#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include <ArcVoter/ArcVoter.h>

#include <utils/SymbolTable.h>

int main(int argc, char** argv)
{
  float radii[300];
  float votes[300];
  if (argc < 2)
    exit(-1);

  utils::SymbolTable* globals = new utils::SymbolTable;
  globals->set("ModuleName", "ArcTester");

  ArcVoter* arc_voter = ArcVoter::create(argv[1], globals);
  if (!arc_voter) {
    printf("Bad arc voter '%s'\n", argv[1]);
    exit(-1);
  }

  printf("Num Arcs %d\n", arc_voter->numArcs());
  int num_arcs = arc_voter->getArcs(radii, 300);
  printf("Arc radii: ");
  int i;
  for (i=0;i<num_arcs;i++) 
    printf("%f ", radii[i]);
  printf("\n");

  arc_voter->setVoteBuffer(votes);
  for (i=0;i<30;i++) {
    memset(votes, 0, 300*sizeof(float));
    votes[i % num_arcs] = i;
    arc_voter->vote();
    sleep(1);
  }

  delete globals;
}
