///////////////////////////////////////////////////////////////////////////////
//
//                                 sharedmem.h
//
// This header file defines the base class for shared memory regions.
// These regions contain flattened data, from which formatted data can
// be extracted.
//
// Classes defined for export:
//    IPSharedMemory
//
//  "1995, Carnegie Mellon University. All Rights Reserved." This
//  software is made available for academic and research purposes only. No
//  commercial license is hereby granted.  Copying and other reproduction is
//  authorized only for research, education, and other non-commercial
//  purposes.  No warranties, either expressed or implied, are made
//  regarding the operation, use, or results of the software.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef IP_SHARED_MEMORY_H
#define IP_SHARED_MEMORY_H

#include <ipt/utils_decl.h>

class IPCommunicator;

class IPSharedMemory {
 public:
  IPSharedMemory(IPCommunicator*, const char* fmt, int max_size);
  virtual ~IPSharedMemory();

  virtual void* FormattedData(int force_copy=0);
  virtual int FormattedData(void*, int force_copy=0);
  virtual int DeleteFormatted(void*);
  virtual int DeleteContents(void*);
  virtual int Data(int& size, unsigned char*& data,
                   int& alignment, int& byte_order) = 0;
  virtual unsigned char* GetInputArea() const = 0;

  virtual unsigned char* GetOutputArea() const { return NULL; }
  virtual int PutData(int size) = 0;
  virtual int PutFormattedData(void*);
  virtual int Valid() const { return 1; }
  virtual int Wait() { return 0; }

  virtual int Tag() const = 0;
  virtual int UpdatedTag() = 0;

  IPFormat* Formatter() const { return _format; }
  int MaxSize() const { return _max_size; }
  int Update();

 protected:
  void SetMaxSize(int ms) { _max_size = ms; }
 private:
  IPFormat* _format;
  int _max_size;
};  

#endif
