#ifndef ipt_posix_shmem_h
#define ipt_posix_shmem_h

#include <ipt/sharedmem.h>

class IPPosixSharedMemory : public IPSharedMemory {
 public:
  IPPosixSharedMemory(IPCommunicator* comm, const char* fmt, int max_size)
    : IPSharedMemory(comm, fmt, max_size)
    {}

  int shmID() const { return _shm_id; }
  int semID() const { return _sem_id; }
  void setIDs(int,int);
  void clear();

 protected:
  int _shm_id, _sem_id;
  unsigned char* _shm;
};

class IPOwnedSharedMemory : public IPPosixSharedMemory {
public:
  IPOwnedSharedMemory(key_t shm_key, key_t sem_key,
                      IPCommunicator* com, const char* fmt,
                      int max_size);
  virtual ~IPOwnedSharedMemory();

  virtual int Data(int& size, unsigned char*& data,
                   int& alignment, int& byte_order);
  virtual unsigned char* GetInputArea() const { return _shm; }
  
  virtual unsigned char* GetOutputArea() const { return _output_area; }
  virtual int PutData(int size);
  virtual int Tag() const { return _tag; }
  virtual int UpdatedTag();
  virtual int Valid() const {
    return _shm_id >= 0 && _sem_id >= 0 && _shm != NULL;
  }

protected:
  IPOwnedSharedMemory(IPCommunicator* com, const char* fmt,
                      int max_size);

private:
  unsigned char* _output_area;
  int _tag;
};

class IPClientSharedMemory : public IPPosixSharedMemory {
public:
  IPClientSharedMemory(key_t shm_key, key_t sem_key, float timeout,
                       IPCommunicator* com, const char* fmt, int max_size);
  virtual ~IPClientSharedMemory();

  virtual int Data(int& size, unsigned char*& data,
                   int& alignment, int& byte_order);
  virtual unsigned char* GetInputArea() const { return _input_area; }
  
  virtual int PutData(int size) { return 0; }
  virtual int Tag() const { return _cur_tag; }
  virtual int UpdatedTag();
  virtual int Valid() const {
    return _shm_id >= 0 && _sem_id >= 0 && _shm != NULL;
  }
  virtual int Wait();

  int lock();
  int unlock();

protected:
  IPClientSharedMemory(IPCommunicator* com, const char* fmt,
                       int max_size);

private:
  unsigned char* _input_area;
  int _cur_tag;
};

#endif
