#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include <sys/user.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>

#include <utils_config.h>

#if defined(__GNU_LIBRARY__) && !defined(_SEM_SEMUN_UNDEFINED)
/* union semun is defined by including <sys/sem.h> */
#else
/* according to X/OPEN we have to define it ourselves */
union semun {
  int val;                    /* value for SETVAL */
  struct semid_ds *buf;       /* buffer for IPC_STAT, IPC_SET */
  unsigned short int *array;  /* array for GETALL, SETALL */
  struct seminfo *__buf;      /* buffer for IPC_INFO */
};
#endif
#if   defined(__ia64__) || defined(ia64) 
/* included from asm/page.h for temp fix
 */
 #define PAGE_SHIFT      14

#define PAGE_SIZE               ((1) << PAGE_SHIFT)
#endif 
void delete_shm(int key)
{
  printf("Deleting memory with key %d\n", key);
  
  int shm_id = shmget(key, PAGE_SIZE, 0666);
  if (shm_id < 0) {
    perror("shmget");
    return;
  }

  if (shmctl(shm_id, IPC_RMID, NULL) < 0) {
    perror("shmctl");
    return;
  }

  printf("Memory deleted\n");
}

void delete_sem(int key)
{
  printf("Deleting semaphore with key %d\n", key);
  
  int sem_id = semget(key, 2, 0666);
  if (sem_id < 0) {
    perror("semget");
    exit(-1);
  }

  union semun un;
  un.val = 0;
  if (semctl(sem_id, 1, IPC_RMID, un) < 0) {
    perror("semctl");
    exit(-1);
  }

  printf("Semaphore deleted\n");
}

int main(int argc, char** argv)
{
  if (argc < 3) {
    printf("Usage: %s <shm_key> <sem_key>\n", argv[0]);
    exit(-1);
  }

  int key = atoi(argv[1]);
  if (key > 0) 
    delete_shm(key);
  
  key = atoi(argv[2]);
  if (key > 0) {
    delete_sem(key);
  }
}
    
