/* Test for direct connections
   Currently a test is

 ./ipttest2 "tcp: port=2000; ModuleName=server;"   

   and

 ./ipttest2 "tcp: port=0; ModuleName=client;" "TCP: host=antenna; port=2000;"

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <ipt/ipt.h>
#include <ipt/connection.h>
#include <ipt/filter.h>
#include <ipt/message.h>
#include <ipt/callbacks.h>
#include <ipt/timer.h>

struct TestType {
    int n;
    char* str;
};

static void ph_handler(IPCommunicator*, IPMessage* msg, void*)
{
    if (!msg)
        return;

    msg->Print(1);
/*    char** data = (char**) msg->FormattedData();
    printf("Received :%s:\n", *data); 
    msg->DeleteFormatted(data); */
}

static int done=0;

static void disconn_handler(IPConnection* conn, void*)
{
  printf("Partner disconnected\n");
  done=1;
}

static void conn_handler(IPConnection* conn, void*)
{
    printf("Connection %x connecting\n", (unsigned int) conn);
}

class TimerTest : public IPTimerCallback
{
  public:
    TimerTest(IPCommunicator* comm, const char* msg)
        { _comm = comm; _msg = msg; }

    virtual void Execute(IPTimer* timer) {
        printf("Timer %x: %s\n", (unsigned int) this, _msg);
        _comm->AddOneShot(timer->interval() + 1.0, this);
    }

  private:
    const char* _msg;
    IPCommunicator* _comm;
};

main(int argc, char** argv)
{
    IPCommunicator* ipt = IPCommunicator::Create(NULL, argv[1]);
    if (!ipt) {
      printf("Cannot create IPT with spec %s\n", argv[1]);
      exit(-1);
    }
    ipt->RegisterNamedFormatter("FooYou", "{ float, int, string }");
    ipt->RegisterMessage(1000, "TestMsg", "{ int, string }");
    ipt->RegisterMessage(1001, "FooType", "{ int, FooYou }");
    ipt->RegisterMessage(1002, "BarType", "{ float, FooYou }");
    IPMessageType* t1 = ipt->LookupMessage("TestMsg");
    ipt->AddConnectCallback(conn_handler);

    if (argc < 3) {
        ipt->PigeonHole(t1);
        ipt->RegisterHandler(t1, ph_handler);
        TimerTest* t = new TimerTest(ipt, "Hello world");
        ipt->AddOneShot(1.0, t);

        printf("Start loop\n");
        while (1) {
            ipt->Sleep(1.0);
            printf(".\n");
        }
    } else {
        printf("Active %s via '%s'\n", argv[1], argv[2]);
        IPConnection* conn = ipt->DirectConnect(argv[2]);
        if (!conn) {
          printf("Could not connect\n");
          exit(-1);
        }
        printf("Connected to %s (%s %x)\n",
               conn->Name(), conn->Host(), (unsigned int) conn);

        conn->AddDisconnectCallback(disconn_handler);

        int i;
        char buffer[100];
        TestType t;
        t.str = buffer;
        for (i=0;i<20;i++) {
            sprintf(buffer, "Hello world %d", i);

            t.n = i;
            ipt->SendMessage(conn, t1, &t);
            printf("Sent %d\n", i);

            ipt->Sleep(1.0);
            if (done)
              break;
        }
    }

    delete ipt;

    return 0;
}
