#include "xbook.h"

#define BASE_COMMAND "xterm -xrm '*allowSendEvents: true'"
#define BASE_PATH "/usr/local/bin/xterm"
/*#define BASE_PATH "/usr/openwin/bin/xterm"*/
#define TRUE 1
#define FALSE 0    

typedef struct WINDOW {
    char *name;
    char *options;
    Window id;
} WINDOW;        

static Display         *display;
static Window root_window;
static char *search_string;
static pid_t last_proc_pid;

init_send(argc, argv )
    int     argc;
    char    *argv[];
{       /* -- main */
    int screen;
    
    /*
     *      Set up X connection 
     */
    display    = SetUpDisplay( argc, argv, &screen );
    root_window = RootWindow( display, screen );
}

Window wait_for_window(window_name,verbose) 
    char *window_name;
    int verbose;
{
    Window window;

    search_string = window_name;
    do {
        if (verbose)
            printf(".");
        fflush(stdout);
        usleep(100);
        window = SearchWindowTree(display, None, root_window,0,FindWindow);
    } while (window == (Window) None);
    if (verbose)
        printf("...Found window %s\n",window_name);

    return(window);
}

Window create_window(window_name,options,blowoff_waiting,verbose)
    char *window_name,*options;
    int blowoff_waiting;
    int verbose;
{
    char command[2*BUFSIZE];
    Window window;
    int pid;

    sprintf(command,"%s -title %s -n %s %s",
            BASE_COMMAND, window_name, window_name, options);

    if ((pid = fork()) != 0) {
        search_string = window_name;
        if (blowoff_waiting)
           return(None);

        do {
            if (verbose)
                printf(".");
            fflush(stdout);
            usleep(100);
            window = SearchWindowTree(display, None, root_window,0,FindWindow);
        } while (window == (Window) None);
        if (verbose)
            printf("...Created window\n");
    } else { 
        execute_command(BASE_PATH,command, verbose);
        fprintf(stderr,
                "Warning: child process couldn't execute `%s'\n",command);
        exit(-1);
    } 
    last_proc_pid = pid;
    return(window);
}

execute_command(path,command, verbose)
    char *path;
    char *command;
{
    static char **argv = NULL;
    char *ptr;
    static max_args = 0;
    char **arg_ptr;
    char *out_ptr;
    int word_found = FALSE;
    int num = 1;
    int i;

    for (ptr = command; *ptr; ptr++) {
        if (*ptr == '\'') {
            ptr++;
            while (*ptr && (*ptr++ != '\''));
            num++;
            continue;
        }
        if (*ptr == '"') {
            ptr++;
            while (*ptr && (*ptr++ != '"'));
            num++;
            continue;
        }

        if (!isspace(*ptr))  {
            if (!word_found)
                num++;
            word_found = TRUE;
        } else
            word_found = FALSE;
    }
    
    if (num > max_args) {
        if (argv)
            argv = (char **) realloc(argv,num*sizeof(char *));
        else
            argv = (char **) malloc(num*sizeof(char *));
        for (i=max_args;i<num;i++) 
            argv[i] = (char *) malloc(BUFSIZE);
        max_args = num;
    }

    arg_ptr = argv;
    word_found = FALSE;
    out_ptr = *arg_ptr;
    for (ptr = command; *ptr; ptr++) {
        if (*ptr == '\'') {
            out_ptr = *arg_ptr;
            ptr++;
            while (*ptr && (*ptr != '\''))
                *out_ptr++ = *ptr++;

            *out_ptr = '\0';
            arg_ptr++;
            word_found = FALSE;
            continue;
        }
        
        if (*ptr == '"') {
            out_ptr = *arg_ptr;
            ptr++;
            while (*ptr && (*ptr != '"'))
                *out_ptr++ = *ptr++;
            *out_ptr = '\0';
            arg_ptr++;
            word_found = FALSE;
            continue;
        }
        
        if (!isspace(*ptr))  {
            if (!word_found) {
                out_ptr = *arg_ptr;
            }
            *out_ptr++ = *ptr;
            word_found = TRUE;
        } else {
            if (word_found) {
                *out_ptr++ = '\0';
                arg_ptr++;
                word_found = FALSE;
            }
        }
    }
    *out_ptr = '\0';
    argv[num-1] = NULL;

    if (verbose) {
        int i;
        printf("Executing %s: \n", path);
        for (i=0;i<num;i++) 
            printf("%d: %s \n",i, argv[i]);

    }
            
    execv(path, argv);
}
    
WINDOW *setup_window(window_name,options,blowoff_waiting,verbose)
    char *window_name,*options;
    int blowoff_waiting;
    int verbose;
{
    Window send_window;
    WINDOW *res;
    
    search_string = window_name;
    send_window = SearchWindowTree(display, None, root_window,0,FindWindow);
    
    if (send_window == (Window) None) {
        send_window = create_window(window_name,options,blowoff_waiting,
                                    verbose);
        if (verbose)
            if (*options == '\0')
                printf("Setting up window `%s' with no options\n",window_name);
            else
                printf("Setting up window `%s' with options `%s'\n",
                       window_name,options);
    } else if (verbose)
        printf("Window `%s' already set up\n",window_name);

    res = (WINDOW *) malloc(sizeof(WINDOW));
    res->name = window_name;
    res->options = options;
    res->id = send_window;

    return(res);
}
 
send_command(window,command,leave_alone,verbose)
    WINDOW *window;
    char *command;
    int leave_alone;
    int verbose;
{
    if (!leave_alone) 
        strcat(command,"\n");

    if (verbose)
        printf("Command: \n%s\n",command);

    SendData(display, window->id, command);
}
            
SendData( display, send_window,send_text )
    Display *display;
    Window  send_window;
    char *send_text;
{       /* -- function SendData */
    
    if ( send_window != (Window) None ) {
        SendString( display, send_window, send_text );
    }
    
    XFlush( display );
}       /* -- function SendData */


Window FindWindow( display, parent, window, level )
    Display *display;
    Window	parent;
    Window  window;
    int     level;
{
    char    *name;
    Window  found;
    
    found = (Window) None;
    
    /* Get the window's name, using the pre-R4 function. */      
    XFetchName( display, window, &name );
    
    /* Check if there is a name */
    if ( name != (char *)NULL ) {
        if ( strcmp( name, search_string ) == 0 ) {
            found = window;
        }
        
        XFree( name );
    }
    
    return( found );
    
}       /* -- function  FindWindow */


pid_t get_last_pid()
{
    return(last_proc_pid);
}
