%module xbook
%{
#include "xbook.h"

extern int x_error;

extern Window SearchWindowTree( Display*, Window, Window, int,
                                Window (*)(Display*, Window, Window, int));
static const char *search_string;

Window FindWindow( Display* display, Window parent, Window window, int level )
{
  char    *name;
  Window  found;
    
  found = (Window) None;
    
    /* Get the window's name, using the pre-R4 function. */      
  XFetchName( display, window, &name );
    
  /* Check if there is a name */
  if ( name != (char *)NULL ) {
    if ( strcmp( name, search_string ) == 0 ) {
      found = window;
    }
        
    XFree( name );
  }
    
  return( found );
    
}       /* -- function  FindWindow */


Window SearchWindow(Display* display, Window root, const char* name)
{
  search_string = name;
  return SearchWindowTree(display, None, root, 0, FindWindow);
}

static void CloseDisplay(Display* display)
{
  XFlush( display );
  XCloseDisplay(display);
}        

static void DestroyWindow(Display* display, Window w)
{
  XDestroyWindow(display, w);
  XFlush(display);
}
    
%}

%include typemaps.i

typedef int Window;

int x_error;

Display* OpenDisplay(const char* display_name, int* OUTPUT);
Window RootWindow(Display* display, int screen);
Window SearchWindow(Display* display, Window root, const char* name);
int SendString(Display* display, Window window, const char* string);
void CloseDisplay(Display* display);
void DestroyWindow(Display*, Window w);
