
/*
 *      display.c
 *      X11 C routines for opening and closing display
 *      connections.
 *
 *      Routines:
 *      Display *SetUpDisplay( argc, argv, &screen )
 *      Display *OpenDisplay( display_name, &screen )
 *      CheckDisplayName( argc, argv, display_name )
 *      CloseDisplay( disp, window, gc )
 *      QuitX( display, error_message, error_file )
 *
 *	Written for Advanced X Window Applications Programming
 *
 */


#include  "xbook.h"


Display *SetUpDisplay( argc, argv, screen )

int     argc;
char    *argv[];
int     *screen;

/*
 *      SetUpDisplay() checks the command-line
 *      parameters for a display name, and then
 *      calls OpenDisplay() to establish a connection
 *      to an X server.
 *
 *      If no connection can be established, the
 *      program will be terminated by a call to
 *      exit().
 *
 */

{       /* -- function SetUpDisplay */
        char    display_name[ 120 ];
        Display *display;


        CheckDisplayName( argc, argv,
                display_name );

        display = OpenDisplay( display_name, 
                                screen );

        if ( display == (Display *) NULL )
                {
                (void) fprintf( stderr, 
                                "Error could not open X display to %s.\n",
                                XDisplayName( display_name ) );
                exit( 1 );
                }

        return( display );

}       /* -- function SetUpDisplay */



int x_error;

static int print_handler(display, error)
Display* display;
XErrorEvent* error;
{
  x_error = 1;
  printf("***** Caught X Error, hopefully continuing ******\n");
  return 0;
}


Display *OpenDisplay( display_name, screen )

char    display_name[];
int     *screen;

/*
 *      OpenDisplay() tries to establish a connection to
 *      an X server.  If successful, it then gets the
 *      number of the default screen (used in many
 *      other X calls).  OpenDisplay() returns NULL
 *      on an error, so if you want to recover from
 *      a bad display name or errors in making
 *      the connection, use OpenDisplay(), rather
 *      than SetUpDisplay().  (For most X applications,
 *      failure to make a display connection is fatal.)
 *
 */


{       /* -- function OpenDisplay */
        Display *display;

        display = XOpenDisplay( display_name );
        x_error = 0;

        if ( display != (Display *)NULL )
                {
                *screen = DefaultScreen( display );
                XSetErrorHandler(print_handler);
                }

        return( display );

}       /* -- function OpenDisplay */





CheckDisplayName( argc, argv, display_name )

int     argc;
char    *argv[];
char    display_name[];

/*
 *      CheckDisplayName() checks the command-line arguments
 *      for a display name specification. It initializes display_name
 *      to NULL, if no -display command-line argument is found.
 *
 */

{       /* -- function CheckDisplayName */
    int     counter;
    
    display_name[ 0 ] = '\0';
    counter           = 1;
    
    while( counter < argc ) {
        if ((*argv[counter] == '-') && (*(argv[counter]+1) == 'd')) {
            counter++;
            if ( counter < argc ) {
                (void) strcpy( display_name, argv[ counter ] );
                return;
            } else {
                (void) fprintf( stderr, 
                               "Error: usage is -display DisplayName\n" );
            }
        }
        
        counter++;
    }
    
}       /* -- function CheckDisplayName */




CloseDisplay( display, window, gc )

Display *display;
Window  window;
GC      gc;

/*
 *      CloseDisplay() collects a common set of routines
 *      executed together for programs that set up windows.
 *
 */

{       /* -- function CloseDisplay */

        XFreeGC( display, gc );

        XDestroySubwindows( display, window );

        XDestroyWindow( display, window );

        XFlush( display );

        XCloseDisplay( display );

}       /* -- function CloseDisplay */



QuitX( display, error_message, error_file )

Display *display;
char    error_message[], error_file[];

/*
 *      QuitX() is called to terminate a program, by calling exit().
 *      QuitX() also prints out an error message to stderr.
 */

{       /* -- function QuitX */

        (void) fprintf( stderr, "ERROR: %s%s\n", 
                error_message,
                error_file );

        XCloseDisplay( display );

        exit( 1 );

}       /* -- function QuitX */


/*
 *      end of file.
 */


