import time
import os
import string
import xbook
import types

BaseCommand = "xterm -xrm '*allowSendEvents: true'"
SearchCommand = "xterm -xrm *allowSendEvents: true"

class WinSender:
    def __init__(self, display_name):
        self.display, self.screen = xbook.OpenDisplay(display_name);
        if self.display=='NULL':
            self.display = None
            raise RuntimeError, "Illegal display name '%s'" % display_name
        self.root = xbook.RootWindow(self.display, self.screen)
        self.windows = {}

    def __del__(self):
        self.display=None

    def close(self):
        if self.display and self.display != 'NULL':
            xbook.CloseDisplay(self.display)

    def getWindow(self, name):
        try:
            w = self.windows[name]
        except KeyError:
            w = xbook.SearchWindow(self.display, self.root, name)
            if w:
                self.windows[name] = w
        return w

    def create(self, name, options, blocking=0):
        w = self.getWindow(name)
        if w:
            return w

        cmd = "%s -title %s %s &> /dev/null &" % (BaseCommand, name, options)
        os.system(cmd)
        if blocking:
            return self.waitForWindow(name)

    def waitForWindow(self, name):
        while 1:
            w = self.getWindow(name)
            if w:
                return w
            if xbook.cvar.x_error:
                print "Got an X error"
                xbook.cvar.x_error = 0
                return None
            
            time.sleep(1)

    def destroyWindow(self, w):
        if type(w) == types.StringType:
            name = w;
            w = self.getWindow(name)
            del self.windows[name];
        else:
            found = 0
            for i in self.windows.items():
                if i[1] == w:
                    del self.windows[i[0]]
                    found = 1
                    break
            if not found:
                raise RuntimeError, "No window %d" % w
        if w:
            xbook.SendString(self.display, w, "exit")
            xbook.DestroyWindow(self.display, w)

    def destroyAll(self):
        p = os.popen('ps -auxw')
        procs = p.readlines()
        p.close()
        for process in procs:
            if string.find(process, SearchCommand) != -1:
                s = string.split(process)
                proc_num = int(string.split(process)[1])
                os.kill(proc_num, 2)

    def sendString(self, w, str):
        if type(w) == types.StringType:
            w = self.getWindow(w)
        status = xbook.SendString(self.display, w, str)
        if status != 1:
            raise RuntimeError, "SendString problem to %d (%d)" % (w, status)
 
if __name__=='__main__':
    w = WinSender(":0.0")
    
    w.create("Win1", "-geom 40x5-0+0 -fn 6x10", 0)
    w.create("Win2", "-geom 40x5-0+80 -fn 6x10", 0)

    print w.windows
    w1 = w.waitForWindow("Win1")
    w2 = w.waitForWindow("Win2")

    w.sendString(w1, """ls
ls -l
""")
    w.sendString("Win2", "ls\n")

    time.sleep(1)
    print w.windows
    w.destroyWindow(w1)
    print w.windows
    w.destroyWindow("Win2")
    print w.windows

