import os
import socket
import sys
import string
import time

import ConfigSource
import SymbolTable

class Unlauncher:
  def __init__(self, server_host, spec=None):
    try:
      cur_host = os.environ['IPTHOST']
      self.host = cur_host
    except KeyError:
      self.host = socket.gethostname()
    self.host = socket.gethostbyname(self.host)
    self.host_name = string.join(string.split(self.host, '.'), '_')
    
    if spec is None:
      spec = 'iptclient: bool report_status=false; spec ipt_spec {unix: string module_name=%s; string host_name=%s;}' % (self.host, server_host)
    self.server_host = socket.gethostbyname(server_host)
    self.symbol_table = SymbolTable.SymbolTable()
    self.server = ConfigSource.ConfigSource(spec, self.symbol_table);

  def unlaunch(self):
    print "Getting modules", "string Hosts.%s.modules" % self.host_name
    modules = \
            self.server.getStrings("string Hosts.%s.modules" % self.host_name)
    print "Launching", modules
    os.system("killall -INT run_iptshmgr iptshmgr")
    time.sleep(1)
    os.system("killall run_iptshmgr iptshmgr")
    os.system("killall run_persistent_module run_vital_module iserver_set Launcher run_iptshmgr iptshmgr")
    commands = []
    for m in modules:
      if m[:8] == 'iptshmgr':
        continue
      try:
        params = \
               self.server.getSubFile("struct Modules.%s" %
                                      string.join(string.split(m, '.'),
                                                  '_'))
      except RuntimeError:
        print m, "has no module information"
        continue
        
      command = params.get("string command", "")
      command = string.split(command, '/')[-1]
      commands.append(command)
      kill_cmd = "killall -INT %s" % command
      print kill_cmd
      os.system(kill_cmd)

    time.sleep(1)
    print "No more mister nice guy"
    for command in commands:
      kill_cmd = "killall %s" % command
      print kill_cmd
      os.system(kill_cmd)

if __name__=='__main__':
  mgr = Unlauncher(sys.argv[1])

  mgr.unlaunch()

  
