import socket
import os
import sys

from RepoMan import *

class RepoSub(RepoMan):
  def __init__(self, host, display=None, no_display=0):
    host = socket.gethostbyname(host)
    ipt_spec = "{unix: module_name=RepoSub%d; host_name=%s;}" % \
               (os.getpid(), host)
    spec = "iptclient: bool report_status=false; spec ipt_spec %s" % ipt_spec
    print "Spec", spec
    RepoMan.__init__(self, spec, display, no_display)

  def initialize(self, active_modules):
    starting_modules = []
    for m in active_modules:
      if self.overridden.has_key(m):
        continue

      try:
        params = self.server.getSubFile("Modules.%s" % m)
      except RuntimeError:
        raise RuntimeError, "Problem accessing module parameters for %s" % m

      if params.get("bool active"):
        print m, "is already marked as active, skipping"
        continue

      if params.get("bool ubiquitous"):
        print m, "is ubiquituos, skipping"
        continue;

      override = params.get("override_module", "")
      if override:
        if type(override) != type(()):
          override = [ override ]
        for o in override:
          self.overridden[o] = m
          print "Overriding", o, m

      starting_modules.append(m)
      required = params.required_modules;
      if required:
        if type(required) != type(()):
          required = [ required ]
        for e in required:
          try:
            e = self.overridden[e]
          except KeyError:
            pass
          active_modules.append(e)

      print "Managing", m
      m = eval(self.make_creation_string(m, params))
      self.manage(m)

      memory_regions = params.get("owned_memory")
      if type(memory_regions) != type(()):
        if memory_regions is None:
          memory_regions = []
        else:
          memory_regions = [ memory_regions ]
      
      for r in memory_regions:
        var_name = "string SharedMemory.%s.owner" % r
        mem_name = self.server.getString(var_name)
        print "\tOwns memory", mem_name
        if len(mem_name) == 0:
          self.server.parseSet(var_name, m.name)

  def run(self):
    self.invoke("run", manager=0)
    
  def setup(self):
    self.invoke("setup", manager=0)

if __name__=='__main__':
  mgr = RepoSub(sys.argv[1])

  print "Initializing"
  mgr.initialize(sys.argv[2:])

  print "Starting windows"
  mgr.startup()

  print "Setup windows"
  mgr.setup()

  print "Run programs"
  mgr.run()
  

  
  
