
/*
 *      xbook.h
 *      A common header file
 *      for all sources in
 *      Advanced X Window Applications Programming
 *
 */


/*
 *      Include the most common 
 *      X11 header files. Note: Xos.h may
 *      give you some grief.  You may have to define
 *      a symbol like "sun" or "i386" to get this
 *      file to compile.  If you have problems (most likely
 *	the compiler bombing out on Xos.h), look into
 *	the file and see what definition you really need.
 *
 */
#include   <stdio.h>
#include   <memory.h>

#include   <X11/Xlib.h>
#include   <X11/Xutil.h>
#include   <X11/Xos.h>
#include   <X11/cursorfont.h>
#include   <X11/keysym.h>
#include   <X11/keysymdef.h>
#include   <X11/Xatom.h>


/*
 *      Default big string size 
 */
#ifndef BUFSIZE
#define BUFSIZE 256
#endif


/*
 *      Define full size for properties. This is an X magic
 *	constant.
 */
#define  FULL_LENGTH    8192


/*
 *      Property name for Property examples.  This is an arbitrary name.
 */
#define PROP_NAME   "__XBOOK" 


/*
 *      Common event mask for top-level windows.
 *      Using this event mask just makes
 *      application development easier.
 */
#define EVENT_MASK      (long)( ButtonPressMask    | \
                                KeyPressMask       | \
                                ExposureMask       | \
                                StructureNotifyMask )


/*
 *      Default cursor
 */
#define DEFAULT_CURSOR  XC_left_ptr



/*
 *      Size of user interface buttons
 */
#define BUTTON_WIDTH    70
#define BUTTON_HEIGHT   24



/*
 *      Declare functions (old-style) that
 *      do not return an int type.
 *
 */

Atom ConvertTarget();

Cursor MakeCursor();

Display *SetUpDisplay();
Display *OpenDisplay();

GC MakeGC();

KeySym Key2Keysym();

Pixmap CreatePixmap();
Pixmap LoadBitmap();

Time LastTimeStamp();
Time PrimaryTimeStamp();

unsigned long Bytes2Long();
unsigned long GetColor();

Window BuildWList();
Window CheckWindow();
Window CreateWindow();

Window FindWindow();
Window FindSendWindow();
Window FindSubWindow();

Window GetParent();

Window PickWindow(); 
Window SearchWindowTree();
Window TopWindow();


XFontStruct *LoadFont();



/*
 *      end of file
 */

