import sys

import IPT

comm = None

def conn_handler(connection):
    print "Connection", connection
    print "Connection %s connecting" % connection.Name()

class PigeonHandler:
    def execute(self, msg):
        print "Got a message"
        msg.Print(1)
        print

class TimerTest:
    def __init__(self, comm, msg):
        self.communicator = comm
        self.msg = msg

    def execute(self, t):
        print "Timer:", self.msg, t.interval()
        self.communicator.AddOneShot(t.interval()+1, self)

def disconn_handler(connection):
    print "Restablishing connection"
    comm = connection.Communicator()
    comm.Connect(connection.Name());
        

def main(mod_name, connect_name=None):
    global comm
    comm = IPT.Communicator_Instance(mod_name)
    comm.RegisterNamedFormatter("FooYou","{ float, int, string}")
    comm.RegisterMessage("TestMsg", "{ int, string }")
    comm.RegisterMessage("FooType", "{ int, FooYou }")
    comm.RegisterMessage("BarType", "{ float, FooYou }") 
    comm.AddConnectCallback(conn_handler)

    if not connect_name:
        print "In Server mode"
        comm.PigeonHole("TestMsg")
        comm.RegisterHandler("TestMsg", PigeonHandler())
        comm.AddOneShot(1.0, TimerTest(comm, "Hello world"))

        print "Start Loop"
        while 1:
            comm.Sleep(1.0)
            print "Loop"
    else:
        print "Active %s to %s" % (mod_name, connect_name)
        conn = comm.Connect(connect_name)
        print "Connected to %s on %s" % (conn.Name(), conn.Host())
        conn.AddDisconnectCallback(disconn_handler)

        for i in range(20):
            comm.SendMessage(conn, "TestMsg", (i, "Hello world %d" % i))
            comm.Sleep(1.0)

if __name__ == '__main__':
    if len(sys.argv) > 2:
        main(sys.argv[1], sys.argv[2])
    else:
        main(sys.argv[1])
