
/*
 *      sendev.c
 *
 *      X11 code to send an event to
 *      a window on the display.
 *
 *      Written for Advanced X Window Applications Programming
 *
 */


#include  "xbook.h"


SendString( display, window, string )
    
    Display *display;
    Window  window;
    char    string[];
    
    /*
     *      SendString() sends a text string as KeyPress/KeyRelease
     *      events to a given window.
     *
     */
    
{       /* -- function SendString */
    int     i, length, status;
    KeySym keysym;
    
    
    length = strlen( string );
    status = 1;
    i      = 0;
    while ( ( i < length ) && ( status != 0 ) ) {
        switch(string[i]) {
          case '\n':
            keysym = XK_Return;
            break;
          case '\t':
            keysym = XK_Tab;
            break;
          case ':':
            keysym = XK_colon;
            break;
          default:
            keysym = string[i];
            break;
        }
        status = SendKeysym( display, window, keysym );
        i++;
    }
    
    return( status );
    
}       /* -- function SendString */


int is_capital_keysym(keysym)
    KeySym keysym;
{
    static KeySym cap_keys[] = { XK_colon,XK_less,XK_greater,XK_question,
                                 XK_exclam,XK_quotedbl,XK_numbersign,XK_dollar,
                                 XK_percent,XK_ampersand,XK_parenleft,
                                 XK_parenright,XK_asterisk,XK_plus,
                                 XK_braceleft,XK_braceright,XK_asciicircum,
                                 XK_underscore,XK_bar,XK_asciitilde };
    int i;
    
    if ((keysym >= XK_A ) && ( keysym <= XK_Z ))
        return(1);

    for (i=0;i<(sizeof(cap_keys)/sizeof(KeySym));i++)  
        if (keysym == cap_keys[i])
            return(1);

    return(0);
}

/*
 *      SendKeySym() sends a given keysym to 
 *      the given window.
 *
 */

SendKeysym( display, window, keysym )
    
    Display *display;
    Window  window;
    KeySym  keysym;
    
{       /* -- functions SendKeysym */
    KeyCode         keycode;
    int             status;
    int             state;
    
    status  = 0;    /* -- default */
    
    
    if ( keysym != NoSymbol ) {
        if (is_capital_keysym(keysym)) {
            state = ShiftMask;
        } else if ((keysym < XK_space) && (keysym > 0)) {
            state = ControlMask;
            keysym += XK_A-1;
        } else {
            state = 0x00;
        }
            
        keycode = XKeysymToKeycode( display, keysym );
            
        if ( keycode != 0 ) {
            status = SendKeyCode( display, window, keycode, state );
        }
    }
    
    XFlush( display );
    
    return( status );
    
}       /* -- functions SendKeysym */


/*
 *      SendKeyCode() sends a keycode to
 *      a window.
 *
 */

SendKeyCode( display, window, keycode, state )
    
    Display *display;
    Window  window;
    KeyCode keycode;
    int     state;
    
    
{       /* -- function SendKeyCode */
    XKeyEvent       event;
    int             status;
    
    event.type        = KeyPress;
    event.display     = display;
    event.window      = window;
    event.root        = RootWindow( display, DefaultScreen( display ) );
    event.keycode     = keycode;
    event.state       = state;
    event.time        = CurrentTime;
    event.same_screen = True;
    event.x           = 0;   
    event.y           = 0;   
    event.x_root      = 0;   
    event.y_root      = 0;   
    event.subwindow   = (Window)None;
    
    
    status = XSendEvent( display, window, False, KeyPressMask,
                         (XEvent*) &event );
    
    
    
    if ( status != 0 )
        {
            event.type     = KeyRelease;
            event.time     = CurrentTime;
            
            status = XSendEvent( display, window, True, 
                                KeyReleaseMask, (XEvent*) &event );
        }
    
    return( status );
    
    
}       /* -- function SendKeyCode */

/*
 *      end of file.
 */



