///////////////////////////////////////////////////////////////////////////////
//
//                               AgentMessages.h
//
// Defines message numbers, names, and formats used for communications between
// agents, for setting up and running remote interfaces, and for controlling
// those interfaces
//
///////////////////////////////////////////////////////////////////////////////

#ifndef agent_messages_h
#define agent_messages_h

#include <AAA/FbLinear.h>
#include <AAA/interfacing/FbControllerActionList.h>

class FoController;
class FoPredicate;
class FoProductInfo;
class FoProductPrototype;
class FoAgentInterface;

struct AgentInsertStruct {
    FoController* controller;
    FoPredicate* predicate;
    FbActionID ref;
    int pos;
    int start_callbacks;
    int finish_callbacks;
    int run_callbacks;
};

// program messages
#define AGENT_QUIT_MSG "AGENT_QUIT_MSG"
#define AGENT_QUIT_FMT NULL
#define AGENT_LAUNCH_MSG "AGENT_LAUNCH_MSG"
#define AGENT_LAUNCH_FMT "string"
#define AGENT_MGR_ATTACH_MSG "AGENT_MGR_ATTACH_MSG"
#define AGENT_MGR_ATTACH_FMT NULL
#define FO_INTF_GET_PROGRAM_OBJ_MSG "FO_INTF_GET_PROGRAM_OBJ_MSG"
#define FO_INTF_GET_PROGRAM_OBJ_FMT NULL
#define FO_INTF_GOT_PROGRAM_OBJ_MSG "FO_INTF_GOT_PROGRAM_OBJ_MSG"
#define FO_INTF_GOT_PROGRAM_OBJ_FMT "string"

// controller action messages
#define AGENT_HELLO_MSG "AGENT_HELLO_MSG"
#define AGENT_HELLO_FMT NULL
#define AGENT_ACK_MSG "AGENT_ACK_MSG"
#define AGENT_ACK_FMT "int"
#define AGENT_INSERT_MSG "AGENT_INSERT_MSG"
#define AGENT_INSERT_FMT "{ string,string,int,int,int,int,int }"
#define AGENT_REMOVE_MSG "AGENT_REMOVE_MSG"
#define AGENT_REMOVE_FMT "int"
#define AGENT_CLEAR_MSG "AGENT_CLEAR_MSG"
#define AGENT_CLEAR_FMT NULL
#define AGENT_TRUNCATE_MSG "AGENT_TRUNCATE_MSG"
#define AGENT_TRUNCATE_FMT "int"
#define AGENT_CTRL_STARTED_MSG "AGENT_CTRL_STARTED_MSG"
#define AGENT_CTRL_STARTED_FMT "int"
#define AGENT_CTRL_FINISHED_MSG "AGENT_CTRL_FINISHED_MSG"
#define AGENT_CTRL_FINISHED_FMT "int"
#define AGENT_CTRL_RUN_MSG "AGENT_CTRL_RUN_MSG"
#define AGENT_CTRL_RUN_FMT "int"

// binding messages
#define AGENT_BIND_AREA_MSG "AGENT_BIND_AREA_MSG"
#define AGENT_BIND_AREA_FMT "string"
#define AGENT_BOUND_AREA_MSG "AGENT_BOUND_AREA_MSG"
#define AGENT_BOUND_AREA_FMT "int"

#define AGENT_BIND_PLATEN_MSG "AGENT_BIND_PLATEN_MSG"
#define AGENT_BIND_PLATEN_FMT "string"
#define AGENT_BOUND_PLATEN_MSG "AGENT_BOUND_PLATEN_MSG"
#define AGENT_BOUND_PLATEN_FMT "{string, string, [float : 16], float, float, float, float, float}"
struct AgentBoundPlatenStruct {
    char* name;
    FoDescription* platen;
    FbMat platen_mat;
    float z, right, top, left, bottom;
};
#define AGENT_BIND_DESCRIPTION_MSG "AGENT_BIND_DESCRIPTION_MSG"
#define AGENT_BIND_DESCRIPTION_FMT "string"
#define AGENT_BOUND_DESCRIPTION_MSG "AGENT_BOUND_DESCRIPTION_MSG"
#define AGENT_BOUND_DESCRIPTION_FMT "{string, [float : 16]}"
struct AgentBoundDescriptionStruct {
    FoDescription* string;
    FbMat local_mat;
};

#define AGENT_BIND_PROTOTYPE_MSG "AGENT_BIND_PROTOTYPE_MSG"
#define AGENT_BIND_PROTOTYPE_FMT "string"
#define AGENT_BOUND_PROTOTYPE_MSG "AGENT_BOUND_PROTOTYPE_MSG"
#define AGENT_BOUND_PROTOTYPE_FMT "string"

// product manipulation messages
#define AGENT_ATTACH_PRODUCT_MSG "AGENT_ATTACH_PRODUCT_MSG"
#define AGENT_ATTACH_PRODUCT_FMT "string"
#define AGENT_DETACH_PRODUCT_MSG "AGENT_DETACH_PRODUCT_MSG"
#define AGENT_DETACH_PRODUCT_FMT "string"
#define AGENT_TRANSFER_PRODUCT_TO_MSG "AGENT_TRANSFER_PRODUCT_TO_MSG"
#define AGENT_TRANSFER_PRODUCT_TO_FMT "{ string, string, string }"
struct AgentTransferProductToStruct {
    char* name;
    FoAgentInterface* source;
    FoProductInfo* info;
};
#define AGENT_TRANSFER_PRODUCT_AWAY_MSG "AGENT_TRANSFER_PRODUCT_AWAY_MSG"
#define AGENT_TRANSFER_PRODUCT_AWAY_FMT "{ string, string }"
struct AgentTransferProductAwayStruct {
    char* name;
    FoAgentInterface* dest;
};

// product manipulation auditing messages
#define AGENT_GENERATE_PRODUCT_NAME_MSG "AGENT_GENERATE_PRODUCT_NAME_MSG"
#define AGENT_GENERATE_PRODUCT_NAME_FMT "string"
#define AGENT_PRODUCT_NAME_GENERATED_MSG "AGENT_PRODUCT_NAME_GENERATED_MSG"
#define AGENT_PRODUCT_NAME_GENERATED_FMT "string"
#define AGENT_AUDIT_PRODUCTS_MSG "AGENT_AUDIT_PRODUCTS_MSG"
#define AGENT_AUDIT_PRODUCTS_FMT NULL
#define AGENT_PRODUCTS_AUDITED_MSG "AGENT_PRODUCTS_AUDITED_MSG"
#define AGENT_PRODUCTS_AUDITED_FMT "int"
#define AGENT_AUDIT_ATTACHMENT_MSG "AGENT_AUDIT_ATTACHMENT_MSG"
#define AGENT_AUDIT_ATTACHMENT_FMT "{ string, string, string } "
struct AgentAuditAttachmentStruct {
    const char* name;
    FoProductInfo* info;
    FoProductPrototype* proto;
};
#define AGENT_AUDIT_DETACHMENT_MSG "AGENT_AUDIT_DETACHMENT_MSG"
#define AGENT_AUDIT_DETACHMENT_FMT "string"
#define AGENT_AUDIT_TRANSFER_TO_MSG "AGENT_AUDIT_TRANSFER_TO_MSG"
#define AGENT_AUDIT_TRANSFER_TO_FMT "{string,string,string,string}"
struct AgentAuditTransferToStruct {
    FoAgentInterface* source;
    const char* name;
    FoProductInfo* info;
    FoProductPrototype* proto;
};
#define AGENT_AUDIT_TRANSFER_AWAY_MSG "AGENT_AUDIT_TRANSFER_AWAY_MSG"
#define AGENT_AUDIT_TRANSFER_AWAY_FMT "{ string, string }"
struct AgentAuditTransferAwayStruct {
    FoAgentInterface* dest;
    const char* name;
};

// courier rendezvous messages 
#define AGENT_INITIATE_RV_MSG "AGENT_INITIATE_RV_MSG"
#define AGENT_INITIATE_RV_FMT "{ string, string, int }"
struct  AgentInitiateRVStruct {
    FoContainer* intf;
    char* tag;
    int blocking;
};
#define AGENT_RV_INITIATED_MSG "AGENT_RV_INITIATED_MSG"
#define AGENT_RV_INITIATED_FMT "string"

// manipulator rendezvous messages
#define AGENT_ACCEPT_RV_MSG "AGENT_ACCEPT_RV_MSG"
#define AGENT_ACCEPT_RV_FMT "string"
#define AGENT_RV_ACCEPTED_MSG "AGENT_RV_ACCEPTED_MSG"
#define AGENT_RV_ACCEPTED_FMT "string"

#define AGENT_START_RV_MSG "AGENT_START_RV_MSG"
#define AGENT_START_RV_FMT "string"
#define AGENT_FINISHED_RV_MSG "AGENT_FINISHED_RV_MSG"
#define AGENT_FINISHED_RV_FMT NULL

#define AGENT_AUDIT_CHANGES_MSG "AGENT_AUDIT_CHANGES_MSG"
#define AGENT_AUDIT_CHANGES_FMT NULL
#define AGENT_CHANGE_MATRIX_MSG "AGENT_CHANGE_MATRIX_MSG"
#define AGENT_CHANGE_MATRIX_FMT "{ string, string, [ float : 16 ] }"
struct AgentChangeMatrixStruct {
    FoContainer* string;
    const char* changed_name;
    FbMat matrix;
};

#define AGENT_INIT_INTF_MSG "AGENT_INIT_INTF_MSG"
#define AGENT_INIT_INTF_FMT NULL
#define AGENT_RESET_INTF_MSG "AGENT_RESET_INTF_MSG"
#define AGENT_RESET_INTF_FMT NULL

#define AGENT_MAKE_RESERVATION_MSG "AGENT_MAKE_RESERVATION_MSG"
#define AGENT_MAKE_RESERVATION_FMT "string"
#define AGENT_TRY_RESERVATION_MSG "AGENT_TRY_RESERVATION_MSG"
#define AGENT_TRY_RESERVATION_FMT "string"
#define AGENT_RESERVATION_MADE_MSG "AGENT_RESERVATION_MADE_MSG"
#define AGENT_RESERVATION_MADE_FMT "int"
#define AGENT_UNRESERVE_MSG "AGENT_UNRESERVE_MSG"
#define AGENT_UNRESERVE_FMT "string"
#define AGENT_CANCEL_RESERVATION_MSG "AGENT_CANCEL_RESERVATION_MSG"
#define AGENT_CANCEL_RESERVATION_FMT "string"

// BoundItem - structure which summarizes a string binding
struct BoundItem {
    FoContainer* string;   // the bound string
    FbMat mat;                // its homogenous transform from the agent
    char* name;               // its name
    /*
    friend int operator==(const BoundItem& b1, const BoundItem& b2) {
        return (b1.string == b2.string && b1.mat == b2.mat);
    }
    */
};

struct FbFileSpec{
    char* name;
    int size;
    unsigned char* data;
};

struct FbCliqueSpec {
    char* name;
    FbList<FoAgentInterface*>* clique;
};

struct ProgramDownloadStruct {
    FbList<FbFileSpec>* modules;
    FbList<BoundItem>* string_database;
    FbList<BoundItem>* agent_database;
    FbList<FbCliqueSpec>* cliques;
};

#define FO_INTF_DOWNLOAD_MSG "FO_INTF_DOWNLOAD_MSG"
#define FO_INTF_DOWNLOAD_FMT "{ (list { string, int, < char : 2> }),  (list { string, [float:16], string }), (list { string, [float:16], string }), (list { string, (list string) } ) }"

#define FO_INTF_GET_DESCRIPTION_MSG "FO_INTF_GET_DESCRIPTION_MSG"
#define FO_INTF_GET_DESCRIPTION_FMT NULL
#define FO_INTF_GOT_DESCRIPTION_MSG "FO_INTF_GOT_DESCRIPTION_MSG"
#define FO_INTF_GOT_DESCRIPTION_FMT "string"

#define FO_INTF_GET_DESCRIPTION_SRC_MSG "FO_INTF_GET_DESCRIPTION_SRC_MSG"
#define FO_INTF_GET_DESCRIPTION_SRC_FMT NULL
#define FO_INTF_GOT_DESCRIPTION_SRC_MSG "FO_INTF_GOT_DESCRIPTION_SRC_MSG"
#define FO_INTF_GOT_DESCRIPTION_SRC_FMT "{string,(list {string,int,<char:2>})}"

#define FO_INTF_STEP_MSG "FO_INTF_STEP_MSG"
#define FO_INTF_STEP_FMT \
	"int"

#endif
