///////////////////////////////////////////////////////////////////////////////
//
//                               PyPackAction.h
//
// Implements an action which packs data into a python object
//
// Classes defined for export:
//     PyPackAction
//     
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_py_pack_action_h
#define utils_py_pack_action_h

#include <utils/formatting/DataAction.h>

struct _object;
typedef _object PyObject;

class PyPackAction : public utils::DataAction {
    UTILS_BASE_HEADER(PyPackAction);
  public:
    PyPackAction(void* data=NULL);
    virtual ~PyPackAction();

    PyObject* getObject() const { return _object; }
    void setObject(PyObject*);
    
    virtual bool actInt();
    virtual bool actShort();
    virtual bool actLong();
    virtual bool actFloat();
    virtual bool actDouble();
    virtual bool actChar();
    virtual bool actLength(int size);

    virtual bool actString();
    virtual bool actPtr(utils::FormatSpec*);

    virtual bool actFixedArray(const utils::Vector<int>& sizes,
                               utils::FormatSpec* fmt);
    virtual bool actVarArray(utils::StructSpec*,
                             const utils::Vector<int>&, utils::FormatSpec*);

    virtual bool actStruct(int size, utils::FormatSpec** elems);

    static PyObject* pack(utils::FormatSpec*, void*);
    static void initClass();

  private:
    void packLong(long);
    void packDouble(double);

  private:
    PyObject* _object;      // the object we are packing into
};

extern void initPyFormatting(utils::FormatParser&);

#endif
