///////////////////////////////////////////////////////////////////////////////
//
//                            PyMessageHandler.h
//
// Defines a message handler subclass which will invoke a python method
// when executed
//
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_py_message_handler
#define utils_py_message_handler

#include <ipt/callbacks.h>

struct _object;
typedef _object PyObject;

class PyMessageHandler : public IPHandlerCallback {
  public:
    PyMessageHandler(PyObject* method); 
    virtual ~PyMessageHandler();

    virtual void Execute(IPMessage*);

    void setMethod(PyObject* method);

  private:
    PyObject* _method;   // the python method to invoke
};

#endif

