///////////////////////////////////////////////////////////////////////////////
//
//                            PyConnectHandler.h
//
// Defines a connection handler subclass which will invoke a python method
// when executed
//
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_py_connection_handler
#define utils_py_connection_handler

#include <ipt/callbacks.h>

struct _object;
typedef _object PyObject;

class PyConnectHandler : public IPConnectionCallback {
  public:
    PyConnectHandler(PyObject* method); 
    virtual ~PyConnectHandler();

    virtual void Execute(IPConnection*);
    virtual const char* getTypeName() const { return "PyConnectHandler"; }

    void setMethod(PyObject* method);
    PyObject* getMethod() const { return _method; }

  private:
    PyObject* _method;   // the python method to invoke
};

#endif

