from Tkinter import *

import tkMessageBox

class MgrCallback:
    def __init__(self, mgr, invoke):
        self.invoke = invoke;
        self.mgr = mgr

    def callback(self):
        self.mgr.invoke(self.invoke)
        

class MgrDisp:
    def __init__(self, mgr, geom='600x120+0-0'):
        self.blocking = 0
        
        self.root = Tk()
        self.root.title("Manager")
        self.root.geometry(geom)
        self.root.overrideredirect(1)

        self.mgr = mgr
        self.root_frame = Frame(self.root)
        self.root_frame.pack(fill=BOTH, expand=1)

        self.mgr_frame = Frame(self.root_frame)
        self.mgr_frame.pack(fill=BOTH, expand=1)

        self.addManagerButton("Create", method=mgr.startup)
        self.addManagerButton("Stop", invoke="stop")
        self.addManagerButton("Destroy", invoke="destroy")
        self.addManagerButton("Quit", method=mgr.quit)

        self.cfg_frame = Frame(self.root_frame)
        self.cfg_frame.pack(fill=BOTH, expand=1)

        self.addConfigButton("Setup", invoke="setup")
        self.addConfigButton("Run", invoke="run")
        self.addConfigButton("Finish", invoke="finish")
        self.pause_button=self.addConfigButton("Pause", method=self.pause)
        self.paused = 0

    def pause(self):
        self.paused = not self.paused
        if self.paused:
            self.pause_button.config(text="Unpause")
        else:
            self.pause_button.config(text="Pause")
        if self.paused:
            self.mgr.invoke("pause")
        else:
            self.mgr.invoke("unpause")

    def addManagerButton(self, label, method=None, invoke=None):
        if not method and not invoke:
            raise RuntimeError, "Need method or invocation for button"
        if method:
            button = Button(self.mgr_frame, text=label, command=method)
        else:
            cb = MgrCallback(self.mgr, invoke)
            button = Button(self.mgr_frame, text=label, command=cb.callback)
        button.pack(side=LEFT, fill=BOTH, expand=1)
        return button

    def addConfigButton(self, label, method=None, invoke=None):
        if not method and not invoke:
            raise RuntimeError, "Need method or invocation for button"
        if method:
            button = Button(self.cfg_frame, text=label, command=method)
        else:
            cb = MgrCallback(self.mgr, invoke)
            button = Button(self.cfg_frame, text=label, command=cb.callback)
        button.pack(side=LEFT, fill=BOTH, expand=1)
        return button

    def update(self):
        self.root.update()

    def alert(self, msg):
      w = Toplevel()
      w.withdraw()
      prev = self.blocking
      self.blocking = 1
      id = self.poll()
      tkMessageBox.showinfo(None, msg, parent=w)
      self.blocking = prev
      w.destroy()

    def ask(self, msg):
      w = Toplevel()
      w.withdraw()
      prev = self.blocking
      self.blocking = 1
      id = self.poll()
      r = tkMessageBox.askquestion(None, msg, parent=w)
      self.blocking = prev
      w.destroy()
      return r

    def poll(self):
        self.mgr.get_communicator().Idle(0.0)
        if self.blocking:
            return self.root.after(100, self.poll)
        return None
        
