from _IPT import *
import _IPT
import _IPTc
import re

class ConnectCallback:
    def __init__(self, method):
        self.method = method

    def execute(self, connection):
        c = Connection(_IPT._ConnectionPtr(connection))
        if callable(self.method):
            self.method(c)
        else:
            self.method.execute(c)

class MessageHandler:
    def __init__(self, method):
        self.method = method

    def execute(self, message):
        m = MessagePtr(message)
        if callable(self.method):
            self.method(m)
        else:
            self.method.execute(m)

class TimerHandler:
    def __init__(self, method):
        self.method = method

    def execute(self, timer):
        t = TimerPtr(timer)
        if callable(self.method):
            self.method(t)
        else:
            self.method.execute(t)

class Connection(_IPT._Connection):
    def __init__(self, _connection):
        self.this = _connection.this;
        self.connect_callbacks = {}
        self.disconnect_callbacks = {}
        
    def AddConnectCallback(self, method):
        cb = ConnectCallback(method)
        self.connect_callbacks[method] = cb
        _IPT._Connection.AddConnectCallback(self, cb)

    def RemoveConnectCallback(self, method):
        cb = self.connect_callbacks[methods]
        _IPT._Connection.RemoveCallback(cb)
        del self.connect_callbacks[methods]

    def AddDisconnectCallback(self, method):
        cb = ConnectCallback(method)
        self.disconnect_callbacks[method] = cb
        _IPT._Connection.AddDisconnectCallback(self, cb)

    def RemoveDisconnectCallback(self, method):
        cb = self.disconnect_callbacks[methods]
        _IPT._Connection.RemoveCallback(cb)
        del self.disconnect_callbacks[methods]

class Communicator(_IPT._Communicator):
    def __init__(self, _communicator):
        self.this = _communicator.this
        self.connect_callbacks = {}
        self.disconnect_callbacks = {}

    def Connect(self, name, context=1):
        return Connection(_IPT._Communicator.Connect(self, name, context));

    def RegisterHandler(self, msg_name, method, spec=1):
        handler = MessageHandler(method)
        _IPT._Communicator.RegisterHandler(self, msg_name, handler, spec)

    def AddConnectCallback(self, method):
        cb = ConnectCallback(method)
        self.connect_callbacks[method] = cb
        _IPT._Communicator.AddConnectCallback(self, cb)

    def RemoveConnectCallback(self, method):
        cb = self.connect_callbacks[methods]
        _IPT._Communicator.RemoveCallback(cb)
        del self.connect_callbacks[methods]

    def AddDisconnectCallback(self, method):
        cb = ConnectCallback(method)
        self.disconnect_callbacks[method] = cb
        _IPT._Communicator.AddDisconnectCallback(self, cb)

    def RemoveDisconnectCallback(self, method):
        cb = self.disconnect_callbacks[methods]
        _IPT._Communicator.RemoveCallback(cb)
        del self.disconnect_callbacks[methods]

    def AddTimer(self, interval, method):
        cb = TimerHandler(method)
        return _IPT._Communicator.AddTimer(self, interval, cb)

    def AddOneShot(self, interval, method):
        cb = TimerHandler(method)
        return _IPT._Communicator.AddOneShot(self, interval, cb)

    def QueryFormatted(self, connection, query_msg, query_data, \
                       repl_msg, timeout = -1.0):
        msg = self.Query(connection, query_msg, query_data, repl_msg, timeout)
        return msg.Data()

def Communicator_Instance(mod_name,*args):
    comm = apply(_IPTc._Communicator_Instance,(mod_name,)+args)
    return Communicator(_IPT._CommunicatorPtr(comm))

def Communicator_Create(mod_name,*args):
    comm = apply(_IPTc._Communicator_Create,(mod_name,)+args)
    return Communicator(_IPT._CommunicatorPtr(comm))

def MessageScan(comm, filename):
    file = open(filename, 'r')
    text = file.read()
    
    pattern = re.compile(r'^#define[\\\s]*(\w*)_FMT[\\\s]*(("(.*)")|NULL)', re.MULTILINE)
    matches = re.findall(pattern, text)

    formats = {}
    for f in matches:
        if f[3] == '':
            fmt = None
        else:
            fmt = f[3]
        formats[f[0]] = fmt

    pattern = re.compile(r'^#define[\\\s]*(\w*)_MSG[\\\s]*"(.*)"', re.MULTILINE)
    matches = re.findall(pattern, text)

    for m in matches:
        msg = m[0]
        try:
            fmt = formats[msg]
        except KeyError:
            print "Warning: Message %s has no equivalent format" % m[0]
            fmt = None

        comm.RegisterMessage(m[1], fmt)
        setattr(comm, m[0], m[1])

if __name__ == '__main__':
    comm = Communicator_Instance("TestHelp")
    MessageScan(comm, 'messages.h')
    print comm.FO_INTF_STEP
    comm.Close()
