import os
import socket
import types
import WinSender
import IPT
from ConfigFile import ConfigFile
import MgrDisp
import types
import traceback

class AttachCallback:
  def __init__(self, mgr, conn, file_name, var_name):
    self.manager = mgr
    self.connection = conn
    self.file_name = file_name
    self.var_name = var_name

  def change_var(self, var):
    try:
      self.manager.communicator.SendMessage(
        self.connection, self.manager.communicator.CONFIG_VAR_SET,
        [ self.var_name, repr(var) ]
        )
    except RuntimeError:
      self.manager.configs[self.file_name].detach(self.var_name)

class Manager:
  def __init__(self, display=None):
    self.managed = []
    if not display:
      display = os.environ['DISPLAY']
    self.logging = 0
    self.sender = WinSender.WinSender(display)
    self.communicator = None
    self.disp = MgrDisp.MgrDisp(self)
    self.finished = 0
    self.configs={}
    self.hosts = {}
    self.num_hosts = 0
    try:
      cur_host = os.environ['IPTHOST']
      self.host = cur_host
    except KeyError:
      self.host = None

  def manage(self, *windows):
    for w in windows:
      self.managed.append(w)
      w.manage(self)

  def startup(self):
    self.invoke("create", manager=0)
    need_wait=0
    for w in self.managed:
      if w.startup():
        need_wait = 1

    return need_wait

  def setup(self):
    self.invoke("setup", manager=0)
    
  def run(self):
    self.invoke("run", manager=0)
    
  def shutdown(self):
    for w in self.windows:
      w.status = 0
    self.sender.destroyAll()

  def destroy(self):
    self.shutdown()

  def invoke(self, routine, manager=1):
    # need protection here from infinite recursion
    if manager:
      try:
        apply(getattr(self.__class__, routine), [self])
        return
      except AttributeError:
        pass

    for window in self.managed:
      window.invoke(routine)

  def update(self, timer):
    self.disp.update()

  def quit(self):
    self.finished = 1

  def register_config(self, name, cf):
    self.configs[name] = cf

  def get_config_handler(self, msg):
    try:
      cf = self.configs[msg.Data()]
      vals = cf.output()
    except KeyError:
      vals = ''
    print "Sending", msg.Data(), vals
    self.communicator.Reply(msg, self.communicator.CONFIGURATION, vals)

  def wait_for(self, name, trys=5):
    for i in range(trys):
      try:
        conn = self.communicator.LookupConnection(name)
        print "Looked up", name, conn
        return conn
      except RuntimeError:
        pass
      self.communicator.Sleep(0.2)

  def attach_config_handler(self, msg):
    data = msg.Data()
    self.communicator.Reply(msg, self.communicator.CONFIG_VAR_ATTACHED,
                            self.register_attachment(msg.Connection(),
                                                     data[0], data[1]))

  def register_attachment(self, conn, file_name, var_name):
    try:
      cf = self.configs[file_name]
      cb = AttachCallback(self, conn, file_name, var_name)
      cf.attach(var_name, cb.change_var)
      return 1
    except KeyError:
      return 0

  def get_communicator(self):
    if not self.communicator:
      self.communicator = IPT.Communicator_Create(socket.gethostname(),
                                                  "server")
      if not self.host:
        self.host = self.communicator.ThisHost()
      IPT.MessageScan(self.communicator,
                      os.path.join(os.environ['UTILS_DIR'],
                                   'include/ConfigSource/Remote.h'))
      self.communicator.RegisterHandler(self.communicator.GET_CONFIGURATION,
                                        self.get_config_handler)
      self.communicator.RegisterHandler(self.communicator.ATTACH_CONFIG_VAR,
                                        self.attach_config_handler)

    return self.communicator

  def serve(self):
    com = self.get_communicator()

    com.AddTimer(0.1, self.update)
    while not self.finished:
      com.Sleep(0.2)
    com.Close()
    self.communicator = None

  def vehInterface(self, y, hostname, clientof, cfg):
    return StateSensor(geom="40x5-300+"+y, host=hostname, font='6x10',
                       preamble="setenv IPTMACHINE " + hostname + "\n",
                       xterm_options='-xrm "*Page:1 0"',
                       clientof=clientof, cfg=cfg)

  def memManager(self, y, hostname, clientof, cfg):
    return MemManager(geom="40x5-0+"+y, host=hostname, font='6x10',
                      preamble="setenv IPTMACHINE " + hostname + "\n",
                      xterm_options='-xrm "*Page:1 0"')

  def addHost(self, hostname, clientof=None, cfg=None):
    if not hostname:
      return
    if self.hosts.has_key(hostname):
      return
    self.hosts[hostname] = clientof
    y = repr(self.num_hosts*100)
    self.manage(self.memManager(y, hostname, clientof, cfg),
                self.vehInterface(y, hostname, clientof, cfg))
    self.num_hosts = self.num_hosts+1

  def get_config(self, cfg):
    if type(cfg) == types.StringType:
      cf = ConfigFile()
      cf.open(cfg+'.cfg')
    else:
      cf = cfg
    return cf


class Basic:
  def __init__(self, geom=None, name='Basic', font = None, xterm_options='',
               dir=None, preamble=None, command=None, host=None):
    self.geom = geom
    self.name = name
    self.dir = dir
    self.preamble=preamble
    self.xterm_options=xterm_options
    self.manager = None
    self.window = None
    if not command:
      self.command = './' + name
    else:
      self.command = command
    self.font = font
    self.status = 0
    self.host = host

  def startup(self):
    if not self.window:
      self.confirm()
      return 1
    else:
      return 0

  def stop(self):
    if not self.status:
      return
    self.manager.sender.sendString(self.window, '\003')
    self.status = 2

  def invoke(self, routine):
    try:
      apply(getattr(self.__class__, routine), [self])
      return 1
    except AttributeError:
      return 0

  def create(self):
    if self.confirm(0):
      self.status=1
      return
    
    if not self.name:
      raise RuntimeError, "Can't create unnamed window"
    if not self.geom:
      raise RuntimeError, "Window %s has no geometry" % self.name
    if self.font:
      font = ' -fn ' + self.font
    else:
      font = ''
    try:
      dest_host = socket.gethostbyname(self.host)
    except TypeError:
      print "****Warning:  No host for %s" % self.name
      dest_host = None
    if self.host and \
       (dest_host != "127.0.0.1") and \
       (dest_host != \
       socket.gethostbyname(self.manager.get_communicator().ThisHost())):
      exec_opt = ' -e ssh -4 %s' % self.host
    else:
      exec_opt = ''

    self.window = self.manager.sender.create(self.name,
      '-geom ' + self.geom + font + ' ' + self.xterm_options + exec_opt, 0)
    self.status = 1

  def manage(self, mgr):
    self.manager = mgr

  def setup(self):
    if not self.status:
      return
    if not self.confirm():
      print "Could not confirm %s for setup" % self.name
      return
    if self.dir:
      self.manager.sender.sendString(self.window, 'cd '+self.dir+'\n')
    if self.preamble:
      self.manager.sender.sendString(self.window, self.preamble)
    self.status = 2

  def destroy(self):
    if not self.status:
      return
    if self.confirm(0):
      if self.window:
        self.manager.sender.destroyWindow(self.window)
    self.status = 0

  def confirm(self, blocking=1):
    if blocking:
      self.window = self.manager.sender.waitForWindow(self.name)
    else:
      self.window = self.manager.sender.getWindow(self.name)

    if not self.window:
      self.status = 0

    return self.window

  def run(self):
    if not self.status:
      return

    self.manager.sender.sendString(self.window, self.command+'\n')
    self.status = 3

class Module(Basic):
  def __init__(self, geom=None, name='Module', font = None, xterm_options='',
               dir=None, preamble=None, command=None, cfg=None, host=None):
    Basic.__init__(self, geom, name, font, xterm_options, dir, preamble,
                  command, host)
    if cfg is None:
      self.cfg = name
    else:
      self.cfg = cfg
    self.cf = None;

  def config(self):
    cf = self.manager.get_config(self.cfg)
    self.manager.register_config(self.name, cf)
    self.cf = cf
    return cf

  def run(self):
    if not self.status:
      return

    cf = self.config()
    cf.set("bool running", 1)

    if self.manager.logging:
      self.manager.sender.sendString(self.window,
                                     'date >> %s.log\n' % self.name)

    ipt_spec = "{unix: module_name=%s; host_name=%s;}" \
               % (self.name, self.manager.host)
    cmd = \
    '%s "remote: name=%s; retry_times=2; retry_wait=0.25; spec ipt_spec %s"'\
        % (self.command, self.name, ipt_spec)
    if self.manager.logging:
      self.manager.sender.sendString(self.window, '%s >> %s.log\n'
                                     % (cmd, self.name))
    else:
      self.manager.sender.sendString(self.window, cmd+'\n')
                                     
    self.status = 3

  def finish(self):
    if self.status < 3:
      return
    try:
      cf = self.manager.configs[self.name]
    except KeyError:
      return
    cf.set("bool running", 0)

  def pause(self):
    if self.status < 3:
      return
    try:
      cf = self.manager.configs[self.name]
    except KeyError:
      return
    cf.set("bool paused", 1)

  def unpause(self):
    if self.status < 3:
      return
    try:
      cf = self.manager.configs[self.name]
    except KeyError:
      return
    cf.set("bool paused", 0)

class InitModule(Module):
  def run(self):
    pass

  def setup(self):
    Module.setup(self)
    if not self.status:
      return
    Module.run(self)

  def finish(self):
    pass

class StateSensor(InitModule):
  memory_managed=0
  def __init__(self, geom=None, font=None, xterm_options='', \
               host=None, clientof=None, cfg=None, preamble=None):
    if not host or not clientof:
      name = 'state_sense'
    else:
      name = 'state_sense.'+host
      cfg = ConfigFile()
      if StateSensor.memory_managed:
        cfg_string = 'spec state_sense_spec { remote: retry_times=3; retry_wait=0.25; host=%s; } spec shmem_spec { managed: name=VehStateArray; owner=true; }' % clientof
      else:
        cfg_string = 'spec state_sense_spec { remote: retry_times=3; retry_wait=0.25; host=%s; }' % clientof
      cfg.parse(cfg_string)
      
    Module.__init__(self, geom=geom, name=name, font=font, \
                    xterm_options=xterm_options,
                    command='state_sense',
                    host=host, cfg=cfg, preamble=preamble)

  def setup(self):
    InitModule.setup(self)

class InitBasic(Basic):
  def run(self):
    pass

  def setup(self):
    Basic.setup(self)
    if not self.status:
      return
    Basic.run(self)


class MemManager(InitBasic):
  def __init__(self, geom=None, font = None, xterm_options='', host=None,
               preamble=None):
    if host:
      name = 'iptshmgr.'+host
    else:
      name = 'iptshmgr'

    InitBasic.__init__(self,geom=geom, font=font, xterm_options=xterm_options,\
                       host=host, name=name, command='iptshmgr',
                       preamble=preamble)
#                       host=host, name=name, command='r ')    

class ZoomTool(Basic):
  def run(self):
    pass

  def setup(self):
    device = self.manager.cfg_file.get("string zoom.device", "/dev/ttyS4")
    zoom = self.manager.cfg_file.get("int zoom.zoom", 180)
    focus = self.manager.cfg_file.get("int zoom.focus", 34800)

    Basic.setup(self)

    self.manager.sender.sendString(self.window,
                                   './set_zoom %s %d\n' % (device, zoom))
    self.manager.sender.sendString(self.window,
                                   './set_focus %s %d\n' % (device, focus))

if __name__=='__main__':
  home = os.environ['UTILS_DIR']
  mgr = Manager()
  try:
    cur_host = os.environ['IPTHOST']
    mgr.host = cur_host
  except KeyError:
    pass
  print "Host is", mgr.host
  try:
    remote_host = os.environ['REMOTE_HOST']
  except KeyError:
    remote_host = None
  mgr.manage(InitModule(geom="80x10-0+0", name="state_sense",
                        dir=home+'/Nav/Controller/StateSensor',
                        host=remote_host),
             Module(geom="80x10-0+160", name="collect",
                    dir=home+'/Nav/Flow/flow', host=remote_host)
             )

  mgr.startup()
  mgr.serve()
