import os
import types

from ConfigManager import Manager,Module,InitModule,Basic,StateSensor
from ConfigFile import ConfigFile

class CentralManager(Manager):
  def __init__(self, cfg_name, display=None):
    Manager.__init__(self, display)
    self.cfg_name = cfg_name
    self.cfg_file = ConfigFile()
    self.cfg_file.open(cfg_name)

  def get_config(self, cfg_name):
    if type(cfg_name) == types.StringType:
      return self.cfg_file.getFile(cfg_name)
    else:
      return cfg_name

  def run(self):
    self.cfg_file = ConfigFile()
    self.cfg_file.open(self.cfg_name)

    Manager.run(self)

  def setup(self):
    self.cfg_file = ConfigFile()
    self.cfg_file.open(self.cfg_name)
    Manager.setup(self)


