/* $Revision: 1.1 $

$Date: 2004/04/26 19:58:43 $

$Author: jayg $*/
/** @file test_textureHeightMap.cc

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION:

*/
/*REVISION HISTORY

$Log: test_textureHeightMap.cc,v $
Revision 1.1  2004/04/26 19:58:43  jayg
First version of GLUtils ripped from Redteam

Revision 1.2  2003/11/17 05:26:17  curmson
Added a second render call, allowing the user to pass a double array instead of just an integer array.

Revision 1.1  2003/11/17 05:19:37  curmson
Added a number of objects for rendering texture mapped stuff.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef TEST_TEXTUREHEIGHTMAP_CC
#define TEST_TEXTUREHEIGHTMAP_CC
#include <GLUtils/glut_window.h>
#include <GLUtils/GL_TexturedHeightMap.h>
#include <Common/PGMImage.h>
#include <iostream>
using namespace std;

int main(int argc, char *argv[]) {

  if (argc!=3) {
    cout << "usage: test_texture PPMImageFile PGMHeightMapFile" << endl;
  }

  PGMImage src;
  src.readRGBImage(argv[1]);

  PGMImage heightSrc;
  heightSrc.readGreyImage(argv[2]);
  int *heights =new int[heightSrc.getWidth()*heightSrc.getHeight()];
  double *dHeights = new double[heightSrc.getWidth()*heightSrc.getHeight()];
  int i;
  for (i=0;i<heightSrc.getWidth()*heightSrc.getHeight();i++) {
    heights[i] = ((int)heightSrc.getImage()[i])-128;
    dHeights[i] = heights[i]*0.5;
  }


  Glut_Window win("texture map",500,500);
  win.set_z_up();
  GL_Origin gl_ori(10);
  GL_TexturedHeightMap gl_map;
  gl_map.render(src.getWidth(),src.getHeight(),src.getImage(),
		heightSrc.getWidth(),heightSrc.getHeight(),heights,
		1,1,0.1,
		r3Vector(0,0),heightSrc.getWidth(),heightSrc.getHeight());


  GL_TexturedHeightMap gl_map2;
  gl_map2.render(src.getWidth(),src.getHeight(),src.getImage(),
		heightSrc.getWidth(),heightSrc.getHeight(),dHeights,
		1,1,
		r3Vector(800,0),heightSrc.getWidth(),heightSrc.getHeight());


  GL_TexturedHeightMap gl_map3;
  gl_map3.render(src.getWidth(),src.getHeight(),src.getImage(),
		heightSrc.getWidth(),heightSrc.getHeight(),heights,
		1,1,0.1,
		r3Vector(800,800),heightSrc.getWidth(),heightSrc.getHeight());

  win.register_object(&gl_map);
  win.register_object(&gl_map2);
  win.register_object(&gl_map3);
  win.register_object(&gl_ori);

  win.set_far_clip(10000);
  win.set_step_size(50);
  win.set_zoom_scale(10);
  win.run();


}



#endif //ifndef TEST_TEXTUREHEIGHTMAP_CC
